/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.transform.impl;

import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.CglibReflectUtils;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.CodeGenerationException;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.cglib.core.TypeUtils;
import cn.taketoday.context.cglib.transform.ClassEmitterTransformer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class AddDelegateTransformer
extends ClassEmitterTransformer {
    private static final String DELEGATE = "$TODAY_DELEGATE";
    private static final Signature CSTRUCT_OBJECT = TypeUtils.parseSignature("void <init>(Object)");
    private Class[] delegateIf;
    private Class delegateImpl;
    private Type delegateType;

    public AddDelegateTransformer(Class[] delegateIf, Class delegateImpl) {
        try {
            delegateImpl.getConstructor(Object.class);
            this.delegateIf = delegateIf;
            this.delegateImpl = delegateImpl;
            this.delegateType = Type.getType(delegateImpl);
        }
        catch (NoSuchMethodException e) {
            throw new CodeGenerationException(e);
        }
    }

    @Override
    public void beginClass(int version, int access, String className, Type superType, Type[] interfaces, String sourceFile) {
        if (Modifier.isInterface(access)) {
            super.beginClass(version, access, className, superType, interfaces, sourceFile);
        } else {
            Class[] delegateIf = this.delegateIf;
            Type[] all = TypeUtils.add(interfaces, TypeUtils.getTypes(delegateIf));
            super.beginClass(version, access, className, superType, all, sourceFile);
            this.declare_field(130, DELEGATE, this.delegateType, null);
            for (int i = 0; i < delegateIf.length; ++i) {
                Method[] methods = delegateIf[i].getMethods();
                for (int j = 0; j < methods.length; ++j) {
                    if (!Modifier.isAbstract(methods[j].getModifiers())) continue;
                    this.addDelegate(methods[j]);
                }
            }
        }
    }

    @Override
    public CodeEmitter beginMethod(int access, Signature sig, Type ... exceptions) {
        CodeEmitter e = super.beginMethod(access, sig, exceptions);
        if (sig.getName().equals("<init>")) {
            return new CodeEmitter(e){
                private boolean transformInit;
                {
                    this.transformInit = true;
                }

                @Override
                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                    if (this.transformInit && opcode == 183) {
                        this.load_this();
                        this.new_instance(AddDelegateTransformer.this.delegateType);
                        this.dup();
                        this.load_this();
                        this.invoke_constructor(AddDelegateTransformer.this.delegateType, CSTRUCT_OBJECT);
                        this.putfield(AddDelegateTransformer.DELEGATE);
                        this.transformInit = false;
                    }
                }
            };
        }
        return e;
    }

    private void addDelegate(Method m) {
        try {
            Method delegate = this.delegateImpl.getMethod(m.getName(), m.getParameterTypes());
            if (!delegate.getReturnType().getName().equals(m.getReturnType().getName())) {
                throw new IllegalArgumentException("Invalid delegate signature " + delegate);
            }
        }
        catch (NoSuchMethodException e) {
            throw new CodeGenerationException(e);
        }
        Signature sig = CglibReflectUtils.getSignature(m);
        Type[] exceptions = TypeUtils.getTypes(m.getExceptionTypes());
        CodeEmitter e = super.beginMethod(1, sig, exceptions);
        e.load_this();
        e.getfield(DELEGATE);
        e.load_args();
        e.invoke_virtual(this.delegateType, sig);
        e.return_value();
        e.end_method();
    }
}

