/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.transform.impl;

import cn.taketoday.context.Constant;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.CglibReflectUtils;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.MethodInfo;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.cglib.transform.ClassEmitterTransformer;
import java.lang.reflect.Method;

public class AddInitTransformer
extends ClassEmitterTransformer {
    private final MethodInfo info;

    public AddInitTransformer(Method method) {
        this.info = CglibReflectUtils.getMethodInfo(method);
        Type[] types = this.info.getSignature().getArgumentTypes();
        if (types.length != 1 || !types[0].equals(Constant.TYPE_OBJECT) || !this.info.getSignature().getReturnType().equals(Type.VOID_TYPE)) {
            throw new IllegalArgumentException(method + " illegal signature");
        }
    }

    @Override
    public CodeEmitter beginMethod(int access, Signature sig, Type ... exceptions) {
        CodeEmitter emitter = super.beginMethod(access, sig, exceptions);
        if (sig.getName().equals("<init>")) {
            return new CodeEmitter(emitter){

                @Override
                public void visitInsn(int opcode) {
                    if (opcode == 177) {
                        this.load_this();
                        this.invoke(AddInitTransformer.this.info);
                    }
                    super.visitInsn(opcode);
                }
            };
        }
        return emitter;
    }
}

