/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.transform.impl;

import cn.taketoday.context.Constant;
import cn.taketoday.context.asm.Label;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.Local;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.cglib.core.TypeUtils;
import cn.taketoday.context.cglib.transform.ClassEmitterTransformer;
import cn.taketoday.context.cglib.transform.impl.InterceptFieldCallback;
import cn.taketoday.context.cglib.transform.impl.InterceptFieldEnabled;
import cn.taketoday.context.cglib.transform.impl.InterceptFieldFilter;
import java.lang.reflect.Modifier;

public class InterceptFieldTransformer
extends ClassEmitterTransformer {
    private static final String CALLBACK_FIELD = "$TODAY_READ_WRITE_CALLBACK";
    private static final Type ENABLED = TypeUtils.parseType(InterceptFieldEnabled.class);
    private static final Type CALLBACK = TypeUtils.parseType(InterceptFieldCallback.class);
    private static final Signature ENABLED_SET = new Signature("setInterceptFieldCallback", Type.VOID_TYPE, Type.array(CALLBACK));
    private static final Signature ENABLED_GET = new Signature("getInterceptFieldCallback", CALLBACK, new Type[0]);
    private InterceptFieldFilter filter;

    public InterceptFieldTransformer(InterceptFieldFilter filter) {
        this.filter = filter;
    }

    @Override
    public void beginClass(int version, int access, String className, Type superType, Type[] interfaces, String sourceFile) {
        if (!Modifier.isInterface(access)) {
            super.beginClass(version, access, className, superType, TypeUtils.add(interfaces, ENABLED), sourceFile);
            super.declare_field(130, CALLBACK_FIELD, CALLBACK, null);
            CodeEmitter e = super.beginMethod(1, ENABLED_GET, new Type[0]);
            e.load_this();
            e.getfield(CALLBACK_FIELD);
            e.return_value();
            e.end_method();
            e = super.beginMethod(1, ENABLED_SET, new Type[0]);
            e.load_this();
            e.load_arg(0);
            e.putfield(CALLBACK_FIELD);
            e.return_value();
            e.end_method();
        } else {
            super.beginClass(version, access, className, superType, interfaces, sourceFile);
        }
    }

    @Override
    public void declare_field(int access, String name, Type type, Object value) {
        super.declare_field(access, name, type, value);
        if (!Modifier.isStatic(access)) {
            if (this.filter.acceptRead(this.getClassType(), name)) {
                this.addReadMethod(name, type);
            }
            if (this.filter.acceptWrite(this.getClassType(), name)) {
                this.addWriteMethod(name, type);
            }
        }
    }

    private void addReadMethod(String name, Type type) {
        CodeEmitter e = super.beginMethod(1, InterceptFieldTransformer.readMethodSig(name, type.getDescriptor()), new Type[0]);
        e.load_this();
        e.getfield(name);
        e.load_this();
        e.invoke_interface(ENABLED, ENABLED_GET);
        Label intercept = e.make_label();
        e.ifnonnull(intercept);
        e.return_value();
        e.mark(intercept);
        Local result = e.make_local(type);
        e.store_local(result);
        e.load_this();
        e.invoke_interface(ENABLED, ENABLED_GET);
        e.load_this();
        e.push(name);
        e.load_local(result);
        e.invoke_interface(CALLBACK, InterceptFieldTransformer.readCallbackSig(type));
        if (!TypeUtils.isPrimitive(type)) {
            e.checkcast(type);
        }
        e.return_value();
        e.end_method();
    }

    private void addWriteMethod(String name, Type type) {
        CodeEmitter e = super.beginMethod(1, InterceptFieldTransformer.writeMethodSig(name, type.getDescriptor()), new Type[0]);
        e.load_this();
        e.dup();
        e.invoke_interface(ENABLED, ENABLED_GET);
        Label skip = e.make_label();
        e.ifnull(skip);
        e.load_this();
        e.invoke_interface(ENABLED, ENABLED_GET);
        e.load_this();
        e.push(name);
        e.load_this();
        e.getfield(name);
        e.load_arg(0);
        e.invoke_interface(CALLBACK, InterceptFieldTransformer.writeCallbackSig(type));
        if (!TypeUtils.isPrimitive(type)) {
            e.checkcast(type);
        }
        Label go = e.make_label();
        e.goTo(go);
        e.mark(skip);
        e.load_arg(0);
        e.mark(go);
        e.putfield(name);
        e.return_value();
        e.end_method();
    }

    @Override
    public CodeEmitter beginMethod(int access, Signature sig, Type ... exceptions) {
        return new CodeEmitter(super.beginMethod(access, sig, exceptions)){

            @Override
            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                Type towner = TypeUtils.fromInternalName(owner);
                switch (opcode) {
                    case 180: {
                        if (!InterceptFieldTransformer.this.filter.acceptRead(towner, name)) break;
                        this.helper(towner, InterceptFieldTransformer.readMethodSig(name, desc));
                        return;
                    }
                    case 181: {
                        if (!InterceptFieldTransformer.this.filter.acceptWrite(towner, name)) break;
                        this.helper(towner, InterceptFieldTransformer.writeMethodSig(name, desc));
                        return;
                    }
                }
                super.visitFieldInsn(opcode, owner, name, desc);
            }

            private void helper(Type owner, Signature sig) {
                this.invoke_virtual(owner, sig);
            }
        };
    }

    private static Signature readMethodSig(String name, String desc) {
        return new Signature("$cglib_read_" + name, "()" + desc);
    }

    private static Signature writeMethodSig(String name, String desc) {
        return new Signature("$cglib_write_" + name, "(" + desc + ")V");
    }

    private static Signature readCallbackSig(Type type) {
        Type remap = InterceptFieldTransformer.remap(type);
        return new Signature("read" + InterceptFieldTransformer.callbackName(remap), remap, Type.array(Constant.TYPE_OBJECT, Constant.TYPE_STRING, remap));
    }

    private static Signature writeCallbackSig(Type type) {
        Type remap = InterceptFieldTransformer.remap(type);
        return new Signature("write" + InterceptFieldTransformer.callbackName(remap), remap, Type.array(Constant.TYPE_OBJECT, Constant.TYPE_STRING, remap, remap));
    }

    private static Type remap(Type type) {
        switch (type.getSort()) {
            case 9: 
            case 10: {
                return Constant.TYPE_OBJECT;
            }
        }
        return type;
    }

    private static String callbackName(Type type) {
        return type == Constant.TYPE_OBJECT ? "Object" : TypeUtils.upperFirst(TypeUtils.getClassName(type));
    }
}

