/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.transform.impl;

import cn.taketoday.context.Constant;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.Block;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.EmitUtils;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.cglib.transform.ClassEmitterTransformer;
import cn.taketoday.context.utils.Assert;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public class UndeclaredThrowableTransformer
extends ClassEmitterTransformer {
    private final Type wrapper;

    public UndeclaredThrowableTransformer(Class wrapper) {
        Constructor<?>[] cstructs;
        this.wrapper = Type.getType(wrapper);
        boolean found = false;
        for (Constructor<?> cstruct : cstructs = wrapper.getConstructors()) {
            Class<?>[] types = cstruct.getParameterTypes();
            if (types.length != 1 || !types[0].equals(Throwable.class)) continue;
            found = true;
            break;
        }
        Assert.isTrue(found, () -> wrapper + " does not have a single-arg constructor that takes a Throwable");
    }

    @Override
    public CodeEmitter beginMethod(int access, Signature sig, final Type ... exceptions) {
        CodeEmitter e = super.beginMethod(access, sig, exceptions);
        if (Modifier.isAbstract(access) || sig.equals(Constant.SIG_STATIC)) {
            return e;
        }
        return new CodeEmitter(e){
            private final Block handler;
            {
                super(wrap);
                this.handler = this.begin_block();
            }

            @Override
            public void visitMaxs(int maxStack, int maxLocals) {
                this.handler.end();
                EmitUtils.wrapUndeclaredThrowable(this, this.handler, exceptions, UndeclaredThrowableTransformer.this.wrapper);
                super.visitMaxs(maxStack, maxLocals);
            }
        };
    }
}

