/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.util;

import cn.taketoday.context.Constant;
import cn.taketoday.context.asm.ClassVisitor;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.ClassEmitter;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.EmitUtils;
import cn.taketoday.context.cglib.core.Local;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.cglib.core.TypeUtils;
import cn.taketoday.context.cglib.util.ParallelSorter;

class ParallelSorterEmitter
extends ClassEmitter {
    private static final Type PARALLEL_SORTER = TypeUtils.parseType(ParallelSorter.class);
    private static final Signature CSTRUCT_OBJECT_ARRAY = TypeUtils.parseConstructor("Object[]");
    private static final Signature NEW_INSTANCE = new Signature("newInstance", PARALLEL_SORTER, new Type[]{Constant.TYPE_OBJECT_ARRAY});
    private static final Signature SWAP = TypeUtils.parseSignature("void swap(int, int)");

    public ParallelSorterEmitter(ClassVisitor v, String className, Object[] arrays) {
        super(v);
        this.beginClass(52, 1, className, PARALLEL_SORTER, null, "<cglibGenerated>");
        EmitUtils.nullConstructor(this);
        EmitUtils.factoryMethod(this, NEW_INSTANCE);
        this.generateConstructor(arrays);
        this.generateSwap(arrays);
        this.endClass();
    }

    private String getFieldName(int index) {
        return "FIELD_" + index;
    }

    private void generateConstructor(Object[] arrays) {
        CodeEmitter e = this.beginMethod(1, CSTRUCT_OBJECT_ARRAY, new Type[0]);
        e.load_this();
        e.super_invoke_constructor();
        e.load_this();
        e.load_arg(0);
        e.super_putfield("a", Constant.TYPE_OBJECT_ARRAY);
        for (int i = 0; i < arrays.length; ++i) {
            Type type = Type.getType(arrays[i].getClass());
            this.declare_field(2, this.getFieldName(i), type, null);
            e.load_this();
            e.load_arg(0);
            e.push(i);
            e.aaload();
            e.checkcast(type);
            e.putfield(this.getFieldName(i));
        }
        e.return_value();
        e.end_method();
    }

    private void generateSwap(Object[] arrays) {
        CodeEmitter e = this.beginMethod(1, SWAP, new Type[0]);
        for (int i = 0; i < arrays.length; ++i) {
            Type type = Type.getType(arrays[i].getClass());
            Type component = TypeUtils.getComponentType(type);
            Local T = e.make_local(type);
            e.load_this();
            e.getfield(this.getFieldName(i));
            e.store_local(T);
            e.load_local(T);
            e.load_arg(0);
            e.load_local(T);
            e.load_arg(1);
            e.array_load(component);
            e.load_local(T);
            e.load_arg(1);
            e.load_local(T);
            e.load_arg(0);
            e.array_load(component);
            e.array_store(component);
            e.array_store(component);
        }
        e.return_value();
        e.end_method();
    }
}

