/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion;

import cn.taketoday.context.conversion.TypeConverter;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.GenericDescriptor;

public interface ConversionService {
    public boolean canConvert(Class<?> var1, GenericDescriptor var2);

    default public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        return this.canConvert(sourceType, GenericDescriptor.valueOf(targetType));
    }

    default public boolean canConvert(Object source, Class<?> targetType) {
        return this.getConverter(source, targetType) != null;
    }

    default public <T> T convert(Object source, Class<T> targetClass) {
        return this.convert(source, GenericDescriptor.valueOf(targetClass));
    }

    public <T> T convert(Object var1, GenericDescriptor var2);

    public TypeConverter getConverter(Class<?> var1, GenericDescriptor var2);

    default public TypeConverter getConverter(Object sourceObject, GenericDescriptor targetType) {
        Assert.notNull(sourceObject, "source object must not be null");
        return this.getConverter(sourceObject.getClass(), targetType);
    }

    default public TypeConverter getConverter(Object source, Class<?> targetType) {
        return this.getConverter(source.getClass(), targetType);
    }

    default public TypeConverter getConverter(Class<?> sourceType, Class<?> targetType) {
        return this.getConverter(sourceType, GenericDescriptor.valueOf(targetType));
    }
}

