/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.ConversionService;
import cn.taketoday.context.conversion.TypeConverter;
import cn.taketoday.context.conversion.support.ArraySourceConverter;
import cn.taketoday.context.utils.CollectionUtils;
import cn.taketoday.context.utils.GenericDescriptor;
import java.lang.reflect.Array;
import java.util.Collection;

final class ArrayToCollectionConverter
extends ArraySourceConverter
implements TypeConverter {
    private final ConversionService conversionService;

    public ArrayToCollectionConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    protected boolean supportsInternal(GenericDescriptor targetType, Class<?> sourceType) {
        return targetType.isCollection();
    }

    @Override
    public Object convert(GenericDescriptor targetType, Object source) {
        int length = Array.getLength(source);
        GenericDescriptor elementType = targetType.getElementDescriptor();
        Collection<Object> target = CollectionUtils.createCollection(targetType.getType(), elementType != null ? elementType.getType() : null, length);
        if (elementType == null) {
            for (int i = 0; i < length; ++i) {
                Object sourceElement = Array.get(source, i);
                target.add(sourceElement);
            }
        } else {
            ConversionService conversionService = this.conversionService;
            for (int i = 0; i < length; ++i) {
                Object sourceElement = Array.get(source, i);
                Object targetElement = conversionService.convert(sourceElement, elementType);
                target.add(targetElement);
            }
        }
        return target;
    }
}

