/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.ConversionService;
import cn.taketoday.context.conversion.support.ArraySourceConverter;
import cn.taketoday.context.utils.GenericDescriptor;
import java.lang.reflect.Array;

final class ArrayToObjectConverter
extends ArraySourceConverter {
    private final ConversionService conversionService;

    public ArrayToObjectConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    protected boolean supportsInternal(GenericDescriptor targetType, Class<?> sourceType) {
        Class<?> componentType = sourceType.getComponentType();
        return this.conversionService.canConvert(componentType, targetType.getType());
    }

    @Override
    public Object convert(GenericDescriptor targetType, Object source) {
        if (targetType.isInstance(source)) {
            return source;
        }
        if (Array.getLength(source) == 0) {
            return null;
        }
        Object firstElement = Array.get(source, 0);
        return this.conversionService.convert(firstElement, targetType);
    }
}

