/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.ConversionService;
import cn.taketoday.context.conversion.TypeConverter;
import cn.taketoday.context.utils.GenericDescriptor;
import java.nio.ByteBuffer;

final class ByteBufferConverter
implements TypeConverter {
    private final ConversionService conversionService;

    public ByteBufferConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public boolean supports(GenericDescriptor targetType, Class<?> sourceType) {
        boolean byteBufferTarget = targetType.isAssignableTo(ByteBuffer.class);
        if (ByteBuffer.class.isAssignableFrom(sourceType)) {
            return byteBufferTarget || targetType.is(byte[].class) || this.conversionService.canConvert(sourceType, targetType);
        }
        return byteBufferTarget && this.matchesToByteBuffer(sourceType);
    }

    private boolean matchesToByteBuffer(Class<?> sourceType) {
        return sourceType == byte[].class || this.conversionService.canConvert(sourceType, byte[].class);
    }

    @Override
    public Object convert(GenericDescriptor targetType, Object source) {
        boolean byteBufferTarget = targetType.isAssignableTo(ByteBuffer.class);
        if (source instanceof ByteBuffer) {
            ByteBuffer buffer = (ByteBuffer)source;
            return byteBufferTarget ? buffer.duplicate() : this.convertFromByteBuffer(buffer, targetType);
        }
        if (byteBufferTarget) {
            return this.convertToByteBuffer(source);
        }
        throw new IllegalStateException("Unexpected source/target types");
    }

    private Object convertFromByteBuffer(ByteBuffer source, GenericDescriptor targetType) {
        byte[] bytes = new byte[source.remaining()];
        source.get(bytes);
        if (targetType.is(byte[].class)) {
            return bytes;
        }
        return this.conversionService.convert((Object)bytes, targetType);
    }

    private Object convertToByteBuffer(Object source) {
        byte[] bytes = (byte[])(source instanceof byte[] ? source : (Object)this.conversionService.convert(source, byte[].class));
        if (bytes == null) {
            return ByteBuffer.wrap(new byte[0]);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(bytes.length);
        byteBuffer.put(bytes);
        return byteBuffer.rewind();
    }
}

