/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.ConversionService;
import cn.taketoday.context.conversion.TypeConverter;
import cn.taketoday.context.conversion.support.ToArrayConverter;
import cn.taketoday.context.utils.CollectionUtils;
import cn.taketoday.context.utils.GenericDescriptor;
import java.lang.reflect.Array;
import java.util.Collection;

final class CollectionToArrayConverter
extends ToArrayConverter
implements TypeConverter {
    final ConversionService conversionService;

    public CollectionToArrayConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    protected boolean supportsInternal(GenericDescriptor targetType, Class<?> sourceType) {
        return CollectionUtils.isCollection(sourceType);
    }

    @Override
    public Object convert(GenericDescriptor targetType, Object source) {
        Class<?> elementType = targetType.getComponentType();
        Collection sourceCollection = (Collection)source;
        Object array = Array.newInstance(elementType, sourceCollection.size());
        int i = 0;
        ConversionService conversionService = this.conversionService;
        for (Object sourceElement : sourceCollection) {
            Object targetElement = conversionService.convert(sourceElement, elementType);
            Array.set(array, i++, targetElement);
        }
        return array;
    }
}

