/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.ConversionService;
import cn.taketoday.context.conversion.support.CollectionSourceConverter;
import cn.taketoday.context.utils.GenericDescriptor;
import cn.taketoday.context.utils.ResolvableType;
import java.util.Collection;

final class CollectionToObjectConverter
extends CollectionSourceConverter {
    private final ConversionService conversionService;

    public CollectionToObjectConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    protected boolean supportsInternal(GenericDescriptor targetType, Class<?> sourceType) {
        ResolvableType resolvableType = ResolvableType.forClass(sourceType).asCollection();
        if (resolvableType.hasGenerics()) {
            ResolvableType generic = resolvableType.getGeneric(0);
            return generic != ResolvableType.NONE && this.conversionService.canConvert(generic.toClass(), targetType);
        }
        return false;
    }

    @Override
    protected Object convertInternal(GenericDescriptor targetType, Collection<?> sourceCollection) {
        if (targetType.isInstance(sourceCollection)) {
            return sourceCollection;
        }
        if (sourceCollection.isEmpty()) {
            return null;
        }
        Object firstElement = sourceCollection.iterator().next();
        return this.conversionService.convert(firstElement, targetType);
    }
}

