/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.ConversionService;
import cn.taketoday.context.conversion.TypeConverter;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.GenericDescriptor;
import cn.taketoday.context.utils.ReflectionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

final class IdToEntityConverter
implements TypeConverter {
    private final ConversionService conversionService;

    public IdToEntityConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public boolean supports(GenericDescriptor targetType, Class<?> sourceType) {
        Method finder = this.getFinder(targetType.getType());
        return finder != null && this.conversionService.canConvert(sourceType, finder.getParameterTypes()[0]);
    }

    @Override
    public Object convert(GenericDescriptor targetType, Object source) {
        Method finder = this.getFinder(targetType.getType());
        Assert.state(finder != null, "No finder method");
        Object id = this.conversionService.convert(source, finder.getParameterTypes()[0]);
        return ReflectionUtils.invokeMethod(finder, source, id);
    }

    private Method getFinder(Class<?> entityClass) {
        boolean localOnlyFiltered;
        Method[] methods;
        String finderMethod = "find" + this.getEntityName(entityClass);
        try {
            methods = entityClass.getDeclaredMethods();
            localOnlyFiltered = true;
        }
        catch (SecurityException ex) {
            methods = entityClass.getMethods();
            localOnlyFiltered = false;
        }
        for (Method method : methods) {
            if (!Modifier.isStatic(method.getModifiers()) || !method.getName().equals(finderMethod) || method.getParameterCount() != 1 || !method.getReturnType().equals(entityClass) || !localOnlyFiltered && !method.getDeclaringClass().equals(entityClass)) continue;
            return method;
        }
        return null;
    }

    private String getEntityName(Class<?> entityClass) {
        String shortName = ClassUtils.getShortName(entityClass);
        int lastDot = shortName.lastIndexOf(46);
        if (lastDot != -1) {
            return shortName.substring(lastDot + 1);
        }
        return shortName;
    }
}

