/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.ConversionService;
import cn.taketoday.context.conversion.TypeConverter;
import cn.taketoday.context.utils.CollectionUtils;
import cn.taketoday.context.utils.GenericDescriptor;
import java.util.ArrayList;
import java.util.Map;

final class MapToMapConverter
implements TypeConverter {
    private final ConversionService conversionService;

    public MapToMapConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public boolean supports(GenericDescriptor targetType, Class<?> sourceType) {
        return targetType.isAssignableTo(Map.class) && Map.class.isAssignableFrom(sourceType);
    }

    @Override
    public Object convert(GenericDescriptor targetType, Object source) {
        boolean copyRequired;
        Map sourceMap = (Map)source;
        boolean bl = copyRequired = !targetType.isInstance(source);
        if (!copyRequired && sourceMap.isEmpty()) {
            return sourceMap;
        }
        GenericDescriptor targetKeyType = targetType.getMapKeyGenericDescriptor();
        GenericDescriptor targetValueType = targetType.getMapValueGenericDescriptor();
        ConversionService conversionService = this.conversionService;
        ArrayList<MapEntry> targetEntries = new ArrayList<MapEntry>(sourceMap.size());
        for (Map.Entry entry : sourceMap.entrySet()) {
            Object sourceKey = entry.getKey();
            Object sourceValue = entry.getValue();
            Object targetKey = MapToMapConverter.convertKey(sourceKey, targetKeyType, conversionService);
            Object targetValue = MapToMapConverter.convertValue(sourceValue, targetValueType, conversionService);
            targetEntries.add(new MapEntry(targetKey, targetValue));
            if (sourceKey == targetKey && sourceValue == targetValue) continue;
            copyRequired = true;
        }
        if (!copyRequired) {
            return sourceMap;
        }
        Map<Object, Object> targetMap = CollectionUtils.createMap(targetType.getType(), targetKeyType != null ? targetKeyType.getType() : null, sourceMap.size());
        for (MapEntry entry : targetEntries) {
            entry.addToMap(targetMap);
        }
        return targetMap;
    }

    private static Object convertKey(Object sourceKey, GenericDescriptor targetType, ConversionService conversionService) {
        if (targetType == null) {
            return sourceKey;
        }
        return conversionService.convert(sourceKey, targetType);
    }

    private static Object convertValue(Object sourceValue, GenericDescriptor targetType, ConversionService conversionService) {
        if (targetType == null) {
            return sourceValue;
        }
        return conversionService.convert(sourceValue, targetType);
    }

    static class MapEntry {
        final Object key;
        final Object value;

        MapEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        void addToMap(Map<Object, Object> map) {
            map.put(this.key, this.value);
        }
    }
}

