/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.AbstractTypeCapable;
import cn.taketoday.context.conversion.Converter;
import cn.taketoday.context.conversion.TypeCapable;
import cn.taketoday.context.exception.ConversionException;
import java.lang.reflect.Array;
import java.util.Collection;

public class NumberConverter
extends AbstractTypeCapable
implements Converter<Object, Number>,
TypeCapable {
    private final boolean primitive;

    public NumberConverter(Class<?> targetClass) {
        super(targetClass);
        this.primitive = targetClass.isPrimitive();
    }

    @Override
    public final Number convert(Object source) {
        if (source == null) {
            return this.convertNull();
        }
        if (source instanceof Number) {
            return this.convertNumber((Number)source);
        }
        if (source instanceof String) {
            String stringSource = (String)source;
            if (stringSource.isEmpty()) {
                return this.convertNull();
            }
            try {
                return this.convertString(stringSource);
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Can't convert a string: '" + source + "' to a number", e);
            }
        }
        return this.convertObject(source);
    }

    protected Number convertNull() {
        return this.primitive ? (Number)this.convertNumber(0) : (Number)null;
    }

    protected Number convertNumber(Number source) {
        return source.intValue();
    }

    protected Number convertString(String source) {
        String stringVal = source.trim();
        return stringVal.isEmpty() ? (Number)this.convertNull() : (Number)this.parseString(stringVal);
    }

    protected Number parseString(String stringVal) {
        return Integer.parseInt(stringVal);
    }

    protected Number convertObject(Object source) {
        if (source.getClass().isArray() && Array.getLength(source) > 0) {
            return this.convert(Array.get(source, 0));
        }
        if (source instanceof Collection) {
            Object next = ((Collection)source).iterator().next();
            return this.convert(next);
        }
        if (source instanceof Character) {
            Character character = (Character)source;
            return this.convertNumber((short)character.charValue());
        }
        if (source instanceof Enum) {
            return this.convertNumber(((Enum)source).ordinal());
        }
        throw new ConversionException("Not support source: '" + source + "' convert to target class: " + this.type);
    }

    public boolean isPrimitive() {
        return this.primitive;
    }
}

