/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.ConversionService;
import cn.taketoday.context.conversion.TypeConverter;
import cn.taketoday.context.utils.CollectionUtils;
import cn.taketoday.context.utils.GenericDescriptor;
import java.util.Collection;

final class ObjectToCollectionConverter
implements TypeConverter {
    private final ConversionService conversionService;

    public ObjectToCollectionConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public boolean supports(GenericDescriptor targetType, Class<?> sourceType) {
        if (targetType.isCollection()) {
            GenericDescriptor elementType = targetType.getGeneric(Collection.class);
            return elementType == null || this.conversionService.canConvert(sourceType, elementType);
        }
        return false;
    }

    @Override
    public Object convert(GenericDescriptor targetType, Object source) {
        GenericDescriptor elementType = targetType.getElementDescriptor();
        Collection<Object> target = CollectionUtils.createCollection(targetType.getType(), elementType != null ? elementType.getType() : null, 1);
        if (elementType == null || elementType.isCollection()) {
            target.add(source);
        } else {
            Object singleElement = this.conversionService.convert(source, elementType);
            target.add(singleElement);
        }
        return target;
    }
}

