/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.ConversionFailedException;
import cn.taketoday.context.conversion.TypeConverter;
import cn.taketoday.context.utils.GenericDescriptor;
import cn.taketoday.context.utils.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class ObjectToObjectConverter
implements TypeConverter {
    private static final Map<Class<?>, Member> conversionMemberCache = new ConcurrentHashMap(32);

    ObjectToObjectConverter() {
    }

    @Override
    public boolean supports(GenericDescriptor targetType, Class<?> sourceType) {
        return !targetType.is(sourceType) && ObjectToObjectConverter.hasConversionMethodOrConstructor(targetType.getType(), sourceType);
    }

    @Override
    public Object convert(GenericDescriptor targetType, Object source) {
        Class<?> sourceClass = source.getClass();
        Member member = ObjectToObjectConverter.getValidatedMember(targetType.getType(), sourceClass);
        try {
            if (member instanceof Method) {
                Method method = (Method)member;
                ReflectionUtils.makeAccessible(method);
                if (!Modifier.isStatic(method.getModifiers())) {
                    return method.invoke(source, new Object[0]);
                }
                return method.invoke(null, source);
            }
            if (member instanceof Constructor) {
                Constructor ctor = (Constructor)member;
                ReflectionUtils.makeAccessible(ctor);
                return ctor.newInstance(source);
            }
        }
        catch (InvocationTargetException ex) {
            throw new ConversionFailedException(ex.getTargetException(), source, targetType);
        }
        catch (Throwable ex) {
            throw new ConversionFailedException(ex, source, targetType);
        }
        throw new IllegalStateException(String.format("No to%3$s() method exists on %1$s, and no static valueOf/of/from(%1$s) method or %3$s(%1$s) constructor exists on %2$s.", sourceClass.getName(), targetType.getName(), targetType.getSimpleName()));
    }

    static boolean hasConversionMethodOrConstructor(Class<?> targetClass, Class<?> sourceClass) {
        return ObjectToObjectConverter.getValidatedMember(targetClass, sourceClass) != null;
    }

    private static Member getValidatedMember(Class<?> targetClass, Class<?> sourceClass) {
        Executable member = conversionMemberCache.get(targetClass);
        if (ObjectToObjectConverter.isApplicable(member, sourceClass)) {
            return member;
        }
        member = ObjectToObjectConverter.determineToMethod(targetClass, sourceClass);
        if (member == null && (member = ObjectToObjectConverter.determineFactoryMethod(targetClass, sourceClass)) == null && (member = ObjectToObjectConverter.determineFactoryConstructor(targetClass, sourceClass)) == null) {
            return null;
        }
        conversionMemberCache.put(targetClass, member);
        return member;
    }

    private static boolean isApplicable(Member member, Class<?> sourceClass) {
        if (member instanceof Method) {
            Method method = (Method)member;
            return !Modifier.isStatic(method.getModifiers()) ? ObjectToObjectConverter.isAssignable(method.getDeclaringClass(), sourceClass) : method.getParameterTypes()[0] == sourceClass;
        }
        if (member instanceof Constructor) {
            Constructor ctor = (Constructor)member;
            return ctor.getParameterTypes()[0] == sourceClass;
        }
        return false;
    }

    private static boolean isAssignable(Class<?> lhsType, Class<?> rhsType) {
        return lhsType.isAssignableFrom(rhsType);
    }

    private static Method determineToMethod(Class<?> targetClass, Class<?> sourceClass) {
        if (String.class == targetClass || String.class == sourceClass) {
            return null;
        }
        Method method = ReflectionUtils.findMethod(sourceClass, "to" + targetClass.getSimpleName());
        return method != null && !Modifier.isStatic(method.getModifiers()) && ObjectToObjectConverter.isAssignable(targetClass, method.getReturnType()) ? method : null;
    }

    private static Method determineFactoryMethod(Class<?> targetClass, Class<?> sourceClass) {
        if (String.class == targetClass) {
            return null;
        }
        Method method = ReflectionUtils.findMethod(targetClass, "valueOf", sourceClass);
        if (!(method != null && Modifier.isStatic(method.getModifiers()) || (method = ReflectionUtils.findMethod(targetClass, "of", sourceClass)) != null && Modifier.isStatic(method.getModifiers()))) {
            method = ReflectionUtils.findMethod(targetClass, "from", sourceClass);
        }
        return method;
    }

    private static Constructor<?> determineFactoryConstructor(Class<?> targetClass, Class<?> sourceClass) {
        try {
            return targetClass.getDeclaredConstructor(sourceClass);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

