/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.ConversionService;
import cn.taketoday.context.conversion.TypeConverter;
import cn.taketoday.context.utils.GenericDescriptor;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Optional;

final class ObjectToOptionalConverter
implements TypeConverter {
    private final ConversionService conversionService;

    public ObjectToOptionalConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public boolean supports(GenericDescriptor targetType, Class<?> sourceType) {
        GenericDescriptor valueType;
        if (targetType.is(Optional.class) && (valueType = targetType.getGeneric(Optional.class)) != null) {
            return this.conversionService.canConvert(sourceType, valueType);
        }
        return false;
    }

    @Override
    public Object convert(GenericDescriptor targetType, Object source) {
        GenericDescriptor elementType = targetType.getGeneric(Optional.class);
        if (source instanceof Optional) {
            Optional optional = (Optional)source;
            if (optional.isPresent()) {
                Object original = optional.get();
                if (elementType != null && !elementType.isInstance(original)) {
                    Object converted = this.conversionService.convert((Object)optional, elementType);
                    return Optional.of(converted);
                }
            }
            return source;
        }
        if (elementType != null) {
            Object target = this.conversionService.convert(source, elementType);
            if (target == null || target.getClass().isArray() && Array.getLength(target) == 0 || target instanceof Collection && ((Collection)target).isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(target);
        }
        return Optional.of(source);
    }
}

