/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.ConversionService;
import cn.taketoday.context.conversion.TypeConverter;
import cn.taketoday.context.utils.CollectionUtils;
import cn.taketoday.context.utils.GenericDescriptor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class StreamConverter
implements TypeConverter {
    private final ConversionService conversionService;

    public StreamConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public boolean supports(GenericDescriptor targetType, Class<?> sourceType) {
        if (Stream.class.isAssignableFrom(sourceType)) {
            return targetType.isCollection() || targetType.isArray();
        }
        if (targetType.is(Stream.class)) {
            return CollectionUtils.isCollection(sourceType) || sourceType.isArray();
        }
        return false;
    }

    @Override
    public Object convert(GenericDescriptor targetType, Object source) {
        if (source instanceof Stream) {
            return this.convertFromStream((Stream)source, targetType);
        }
        GenericDescriptor elementDescriptor = targetType.getElementDescriptor();
        if (elementDescriptor == null) {
            if (source instanceof Collection) {
                return ((Collection)source).stream();
            }
            if (source instanceof Object[]) {
                return Arrays.stream((Object[])source);
            }
        } else {
            if (source instanceof Collection) {
                Collection collection = (Collection)source;
                ArrayList target = new ArrayList(collection.size());
                for (Object element : collection) {
                    Object converted = this.conversionService.convert(element, elementDescriptor);
                    target.add(converted);
                }
                return target.stream();
            }
            if (source instanceof Object[]) {
                Object[] sourceArray = (Object[])source;
                ArrayList target = new ArrayList(sourceArray.length);
                for (Object element : sourceArray) {
                    Object converted = this.conversionService.convert(element, elementDescriptor);
                    target.add(converted);
                }
                return target.stream();
            }
        }
        throw new IllegalStateException("Unexpected source/target types");
    }

    protected Object convertFromStream(Stream<?> source, GenericDescriptor targetType) {
        GenericDescriptor elementType = targetType.getElementDescriptor();
        if (elementType != null) {
            final class MapFunction
            implements UnaryOperator<Object> {
                final GenericDescriptor elementType;

                MapFunction(GenericDescriptor elementType) {
                    this.elementType = elementType;
                }

                @Override
                public Object apply(Object original) {
                    return StreamConverter.this.conversionService.convert(original, this.elementType);
                }
            }
            if (targetType.isCollection()) {
                return source.map(new MapFunction(elementType)).collect(Collectors.toCollection(() -> CollectionUtils.createCollection(targetType.getType(), elementType.getType(), 16)));
            }
            return source.map(new MapFunction(elementType)).toArray(count -> (Object[])Array.newInstance(elementType.getType(), count));
        }
        if (targetType.isCollection()) {
            return source.collect(Collectors.toCollection(() -> CollectionUtils.createCollection(targetType.getType(), null, 16)));
        }
        return source.toArray(count -> (Object[])Array.newInstance(elementType.getType(), count));
    }
}

