/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.ConversionService;
import cn.taketoday.context.conversion.support.ToArrayConverter;
import cn.taketoday.context.utils.GenericDescriptor;
import cn.taketoday.context.utils.StringUtils;
import java.lang.reflect.Array;

final class StringToArrayConverter
extends ToArrayConverter {
    private final ConversionService conversionService;

    public StringToArrayConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    protected boolean supportsInternal(GenericDescriptor targetType, Class<?> sourceType) {
        return sourceType == String.class;
    }

    @Override
    public Object convert(GenericDescriptor targetType, Object source) {
        String string = (String)source;
        String[] fields = StringUtils.split(string);
        Class<?> targetElementType = targetType.getComponentType();
        Object target = Array.newInstance(targetElementType, fields.length);
        ConversionService conversionService = this.conversionService;
        for (int i = 0; i < fields.length; ++i) {
            String sourceElement = fields[i];
            Object targetElement = conversionService.convert((Object)sourceElement.trim(), targetElementType);
            Array.set(target, i, targetElement);
        }
        return target;
    }
}

