/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.TypeConverter;
import cn.taketoday.context.conversion.support.StringSourceTypeConverter;
import cn.taketoday.context.utils.GenericDescriptor;
import java.util.HashSet;

public final class StringToBooleanConverter
extends StringSourceTypeConverter
implements TypeConverter {
    public static final HashSet<String> trueValues = new HashSet(8);
    public static final HashSet<String> falseValues = new HashSet(8);

    @Override
    public boolean supportsInternal(GenericDescriptor targetType, Class<?> sourceType) {
        return targetType.is(Boolean.TYPE) || targetType.is(Boolean.class);
    }

    @Override
    protected Object convertInternal(GenericDescriptor targetType, String source) {
        String value = source.trim();
        if (value.isEmpty()) {
            if (targetType.is(Boolean.class)) {
                return null;
            }
            return Boolean.FALSE;
        }
        if (trueValues.contains(value = value.toLowerCase())) {
            return Boolean.TRUE;
        }
        if (falseValues.contains(value)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Invalid boolean value '" + source + "'");
    }

    static {
        trueValues.add("true");
        trueValues.add("on");
        trueValues.add("yes");
        trueValues.add("1");
        falseValues.add("false");
        falseValues.add("off");
        falseValues.add("no");
        falseValues.add("0");
    }
}

