/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.AbstractTypeCapable;
import cn.taketoday.context.conversion.Converter;

final class StringToCharacterConverter
extends AbstractTypeCapable
implements Converter<String, Character> {
    protected StringToCharacterConverter(Class<?> type) {
        super(type);
    }

    @Override
    public Character convert(String source) {
        if (source.isEmpty()) {
            return null;
        }
        if (source.length() > 1) {
            throw new IllegalArgumentException("Can only convert a [String] with length of 1 to a [Character]; string value '" + source + "'  has length of " + source.length());
        }
        return Character.valueOf(source.charAt(0));
    }
}

