/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.ConversionFailedException;
import cn.taketoday.context.conversion.support.StringSourceTypeConverter;
import cn.taketoday.context.io.Resource;
import cn.taketoday.context.utils.GenericDescriptor;
import cn.taketoday.context.utils.ResourceUtils;
import java.io.File;
import java.net.URI;
import java.net.URL;

final class StringToResourceConverter
extends StringSourceTypeConverter {
    StringToResourceConverter() {
    }

    @Override
    public boolean supportsInternal(GenericDescriptor targetType, Class<?> source) {
        Class<?> targetClass = targetType.getType();
        return targetClass == Resource.class || targetClass == URI.class || targetClass == URL.class || targetClass == File.class || targetClass == Resource[].class;
    }

    @Override
    protected Object convertInternal(GenericDescriptor targetType, String source) {
        Class<?> targetClass = targetType.getType();
        try {
            if (targetClass == Resource[].class) {
                return ResourceUtils.getResources(source);
            }
            Resource resource = ResourceUtils.getResource(source);
            if (targetClass == File.class) {
                return resource.getFile();
            }
            if (targetClass == URL.class) {
                return resource.getLocation();
            }
            if (targetClass == URI.class) {
                return resource.getLocation().toURI();
            }
            return resource;
        }
        catch (Throwable e) {
            throw new ConversionFailedException(e, source, targetType);
        }
    }
}

