/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.exception;

import cn.taketoday.context.factory.BeanDefinition;
import cn.taketoday.context.factory.BeansException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class BeanInstantiationException
extends BeansException {
    private static final long serialVersionUID = 1L;
    private final Class<?> beanClass;
    private final Method constructingMethod;
    private final Constructor<?> constructor;

    public BeanInstantiationException(BeanDefinition def, String msg) {
        this(def.getBeanClass(), msg, null);
    }

    public BeanInstantiationException(Class<?> beanClass, String msg) {
        this(beanClass, msg, null);
    }

    public BeanInstantiationException(Class<?> beanClass, String msg, Throwable cause) {
        super("Failed to instantiate [" + beanClass.getName() + "]: " + msg, cause);
        this.beanClass = beanClass;
        this.constructor = null;
        this.constructingMethod = null;
    }

    public BeanInstantiationException(Constructor<?> constructor, String msg, Throwable cause) {
        super("Failed to instantiate [" + constructor.getDeclaringClass().getName() + "]: " + msg, cause);
        this.beanClass = constructor.getDeclaringClass();
        this.constructor = constructor;
        this.constructingMethod = null;
    }

    public BeanInstantiationException(Method constructingMethod, String msg, Throwable cause) {
        super("Failed to instantiate [" + constructingMethod.getReturnType().getName() + "]: " + msg, cause);
        this.beanClass = constructingMethod.getReturnType();
        this.constructor = null;
        this.constructingMethod = constructingMethod;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public Method getConstructingMethod() {
        return this.constructingMethod;
    }
}

