/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.Scope;
import cn.taketoday.context.exception.NoSuchBeanDefinitionException;
import cn.taketoday.context.factory.BeanDefinition;
import cn.taketoday.context.factory.BeansException;
import cn.taketoday.context.factory.ObjectSupplier;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface BeanFactory {
    public static final String FACTORY_BEAN_PREFIX = "$";
    public static final char FACTORY_BEAN_PREFIX_CHAR = '$';

    public Object getBean(String var1) throws BeansException;

    public <T> T getBean(Class<T> var1);

    public <T> T getBean(String var1, Class<T> var2);

    public boolean isSingleton(String var1) throws NoSuchBeanDefinitionException;

    public boolean isPrototype(String var1) throws NoSuchBeanDefinitionException;

    public Class<?> getType(String var1) throws NoSuchBeanDefinitionException;

    public Set<String> getAliases(Class<?> var1);

    public String getBeanName(Class<?> var1) throws NoSuchBeanDefinitionException;

    default public <T> List<T> getBeans(Class<T> requiredType) {
        return new ArrayList<T>(this.getBeansOfType(requiredType).values());
    }

    default public <T> Map<String, T> getBeansOfType(Class<T> requiredType) {
        return this.getBeansOfType(requiredType, true);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> var1, boolean var2);

    public <T> Map<String, T> getBeansOfType(Class<T> var1, boolean var2, boolean var3);

    public Map<String, BeanDefinition> getBeanDefinitions();

    public Object getBean(BeanDefinition var1);

    public Object getScopeBean(BeanDefinition var1, Scope var2);

    public <T> ObjectSupplier<T> getBeanSupplier(Class<T> var1);

    public <T> ObjectSupplier<T> getBeanSupplier(BeanDefinition var1);

    default public Set<String> getBeanNamesOfType(Class<?> requiredType) {
        return this.getBeanNamesOfType(requiredType, true);
    }

    public Set<String> getBeanNamesOfType(Class<?> var1, boolean var2);

    public Set<String> getBeanNamesOfType(Class<?> var1, boolean var2, boolean var3);

    default public <T> List<T> getAnnotatedBeans(Class<? extends Annotation> annotationType) throws BeansException {
        return new ArrayList<Object>(this.getBeansOfAnnotation(annotationType).values());
    }

    default public Map<String, Object> getBeansOfAnnotation(Class<? extends Annotation> annotationType) throws BeansException {
        return this.getBeansOfAnnotation(annotationType, true);
    }

    public Map<String, Object> getBeansOfAnnotation(Class<? extends Annotation> var1, boolean var2) throws BeansException;

    public <A extends Annotation> A getAnnotationOnBean(String var1, Class<A> var2) throws NoSuchBeanDefinitionException;

    public boolean isFullPrototype();

    public boolean isFullLifecycle();
}

