/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.AbstractApplicationContext;
import cn.taketoday.context.factory.ConfigurableBeanFactory;
import cn.taketoday.expression.BeanNameResolver;

public class BeanFactoryResolver
extends BeanNameResolver {
    private final ConfigurableBeanFactory beanFactory;

    public BeanFactoryResolver(ConfigurableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public BeanFactoryResolver(AbstractApplicationContext beanFactory) {
        this(beanFactory.getBeanFactory());
    }

    @Override
    public boolean isReadOnly(String beanName) {
        return true;
    }

    @Override
    public boolean isNameResolved(String beanName) {
        return this.beanFactory.containsBeanDefinition(beanName);
    }

    @Override
    public Object getBean(String beanName) {
        return this.beanFactory.getBean(beanName);
    }
}

