/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.Constant;
import cn.taketoday.context.conversion.ConversionService;
import cn.taketoday.context.conversion.support.DefaultConversionService;
import cn.taketoday.context.exception.BeanInstantiationException;
import cn.taketoday.context.exception.NoSuchPropertyException;
import cn.taketoday.context.reflect.ConstructorAccessor;
import cn.taketoday.context.reflect.NullConstructor;
import cn.taketoday.context.reflect.PropertyAccessor;
import cn.taketoday.context.utils.AbstractAnnotatedElement;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.GenericDescriptor;
import cn.taketoday.context.utils.Mappings;
import cn.taketoday.context.utils.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BeanProperty
extends AbstractAnnotatedElement {
    private static final long serialVersionUID = 1L;
    private static final Mappings<Annotation[], BeanProperty> annotationsCache = new Mappings();
    private final Field field;
    private final Class<?> fieldType;
    private ConstructorAccessor constructor;
    private PropertyAccessor propertyAccessor;
    private Type[] genericClass;
    private Type componentType;
    private boolean componentResolved;
    private ConstructorAccessor componentConstructor;
    private ConversionService conversionService = DefaultConversionService.getSharedInstance();
    private Annotation[] annotations;
    private GenericDescriptor typeDescriptor;

    public BeanProperty(Field field) {
        Assert.notNull((Object)field, "field must not be null");
        this.field = field;
        this.fieldType = field.getType();
    }

    public Object newInstance() {
        return this.newInstance(null);
    }

    public Object newInstance(Object[] args) {
        ConstructorAccessor constructor = this.constructor;
        if (constructor == null) {
            Class<?> fieldType = this.fieldType;
            if (ClassUtils.primitiveTypes.contains(fieldType)) {
                throw new BeanInstantiationException(fieldType, "Cannot be instantiated a simple type");
            }
            this.constructor = constructor = ReflectionUtils.newConstructorAccessor(fieldType);
        }
        return constructor.newInstance(args);
    }

    public Object newArrayInstance(int length) {
        Class<?> type = this.fieldType;
        if (type.isArray()) {
            type = type.getComponentType();
        }
        return Array.newInstance(type, length);
    }

    public Object getValue(Object object) {
        return this.obtainAccessor().get(object);
    }

    public Object getValue(Object object, Class<?> requiredType) {
        Object value = this.getValue(object);
        if (requiredType.isInstance(value)) {
            return value;
        }
        ConversionService conversionService = this.getConversionService();
        if (conversionService == null) {
            conversionService = DefaultConversionService.getSharedInstance();
            this.setConversionService(conversionService);
        }
        return conversionService.convert(value, requiredType);
    }

    public final void setValue(Object obj, Object value) {
        if (!this.fieldType.isInstance(value)) {
            GenericDescriptor typeDescriptor;
            ConversionService conversionService = this.getConversionService();
            if (conversionService == null) {
                conversionService = DefaultConversionService.getSharedInstance();
                this.setConversionService(conversionService);
            }
            if ((typeDescriptor = this.getTypeDescriptor()) == null) {
                this.typeDescriptor = typeDescriptor = GenericDescriptor.ofProperty(this);
            }
            value = conversionService.convert(value, typeDescriptor);
        }
        this.setDirectly(obj, value);
    }

    public final void setDirectly(Object obj, Object value) {
        this.obtainAccessor().set(obj, value);
    }

    public GenericDescriptor getTypeDescriptor() {
        return this.typeDescriptor;
    }

    public PropertyAccessor obtainAccessor() {
        PropertyAccessor propertyAccessor = this.propertyAccessor;
        if (propertyAccessor == null) {
            this.propertyAccessor = propertyAccessor = this.createAccessor();
        }
        return propertyAccessor;
    }

    protected PropertyAccessor createAccessor() {
        return ReflectionUtils.newPropertyAccessor(this.field);
    }

    public Object newComponentInstance() {
        return this.newComponentInstance(null);
    }

    public Object newComponentInstance(Object[] args) {
        if (this.componentConstructor == null) {
            Class<?> componentClass = this.getComponentClass();
            this.componentConstructor = componentClass == null ? NullConstructor.INSTANCE : ReflectionUtils.newConstructorAccessor(componentClass);
        }
        return this.componentConstructor.newInstance(args);
    }

    public Type[] getGenerics() {
        Type[] genericClass = this.genericClass;
        if (genericClass == null) {
            genericClass = ClassUtils.getGenericTypes(this.field);
            this.genericClass = genericClass;
        }
        return genericClass;
    }

    public Type getGeneric(int index) {
        Type[] generics = this.getGenerics();
        if (generics != null && generics.length > index) {
            return generics[index];
        }
        return null;
    }

    public Type getComponentType() {
        if (this.componentResolved) {
            return this.componentType;
        }
        Class<?> fieldType = this.fieldType;
        if (fieldType.isArray()) {
            this.setComponentType(fieldType.getComponentType());
        } else if (Map.class.isAssignableFrom(fieldType)) {
            this.setComponentType(this.getGeneric(1));
        } else {
            this.setComponentType(this.getGeneric(0));
        }
        return this.componentType;
    }

    public Class<?> getComponentClass() {
        Type rawType;
        Type componentType = this.getComponentType();
        if (componentType instanceof Class) {
            return (Class)componentType;
        }
        if (componentType instanceof ParameterizedType && (rawType = ((ParameterizedType)componentType).getRawType()) instanceof Class) {
            return (Class)rawType;
        }
        return null;
    }

    public boolean isInstance(Object value) {
        return this.fieldType.isInstance(value);
    }

    public ConstructorAccessor getConstructor() {
        return this.constructor;
    }

    public PropertyAccessor getPropertyAccessor() {
        return this.propertyAccessor;
    }

    public void setComponentType(Type componentType) {
        this.componentType = componentType;
        if (componentType != null) {
            this.componentResolved = true;
        }
    }

    public void setConstructor(ConstructorAccessor constructor) {
        this.constructor = constructor;
    }

    public void setPropertyAccessor(PropertyAccessor propertyAccessor) {
        this.propertyAccessor = propertyAccessor;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public boolean isMap() {
        return Map.class.isAssignableFrom(this.fieldType);
    }

    public boolean isList() {
        return List.class.isAssignableFrom(this.fieldType);
    }

    public boolean isArray() {
        return this.fieldType.isArray();
    }

    public Class<?> getType() {
        return this.fieldType;
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.field.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BeanProperty)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BeanProperty that = (BeanProperty)o;
        return Objects.equals(this.field, that.field);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.field);
    }

    public String toString() {
        return this.getType().getSimpleName() + " " + this.getName();
    }

    @Override
    public Annotation[] getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.resolveAnnotations();
        }
        return this.annotations;
    }

    private Annotation[] resolveAnnotations() {
        return annotationsCache.get((Object)this, k -> {
            ArrayList annotations = new ArrayList();
            Method readMethod = this.obtainAccessor().getReadMethod();
            Method writeMethod = this.obtainAccessor().getWriteMethod();
            if (writeMethod != null) {
                Collections.addAll(annotations, writeMethod.getAnnotations());
            }
            if (readMethod != null) {
                Collections.addAll(annotations, readMethod.getAnnotations());
            }
            Collections.addAll(annotations, this.field.getAnnotations());
            return annotations.toArray(Constant.EMPTY_ANNOTATION_ARRAY);
        });
    }

    public boolean isReadOnly() {
        return Modifier.isFinal(this.field.getModifiers());
    }

    public static BeanProperty of(Class<?> targetClass, String name) {
        Field field = ReflectionUtils.findField(targetClass, name);
        if (field == null) {
            throw new NoSuchPropertyException(targetClass, name);
        }
        return new BeanProperty(field);
    }
}

