/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.exception.NoSuchBeanDefinitionException;
import cn.taketoday.context.factory.AbstractBeanFactory;
import cn.taketoday.context.factory.AbstractPropertySetter;
import cn.taketoday.context.factory.BeanDefinition;
import cn.taketoday.context.factory.Prototypes;
import cn.taketoday.context.utils.Assert;
import java.lang.reflect.Field;
import java.util.Objects;

public class BeanReferencePropertySetter
extends AbstractPropertySetter {
    private final String referenceName;
    private final boolean required;
    private final Class<?> referenceClass;
    private boolean prototype = false;
    private BeanDefinition reference;

    public BeanReferencePropertySetter(String referenceName, boolean required, Field field) {
        super(field);
        Assert.notNull((Object)referenceName, "Bean name can't be null");
        this.referenceName = referenceName;
        this.required = required;
        this.referenceClass = field.getType();
    }

    @Override
    protected Object resolveValue(AbstractBeanFactory beanFactory) {
        Object value = this.resolveBeanReference(beanFactory);
        if (value == null) {
            if (this.required) {
                throw new NoSuchBeanDefinitionException(this.reference.getName(), this.referenceClass);
            }
            return DO_NOT_SET;
        }
        return value;
    }

    protected Object resolveBeanReference(AbstractBeanFactory beanFactory) {
        String name = this.referenceName;
        Class<?> type = this.getReferenceClass();
        if (beanFactory.isFullPrototype() && this.prototype && beanFactory.containsBeanDefinition(name)) {
            return Prototypes.newProxyInstance(type, beanFactory.getBeanDefinition(name), beanFactory);
        }
        BeanDefinition reference = this.getReference();
        if (reference != null) {
            return beanFactory.getBean(reference);
        }
        Object bean = beanFactory.getBean(name, type);
        return bean != null ? bean : beanFactory.doGetBeanForType(type);
    }

    public boolean isRequired() {
        return this.required;
    }

    public Class<?> getReferenceClass() {
        return this.referenceClass;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public void applyPrototype() {
        this.prototype = true;
    }

    public boolean isPrototype() {
        return this.prototype;
    }

    public void setPrototype(boolean prototype) {
        this.prototype = prototype;
    }

    public BeanDefinition getReference() {
        return this.reference;
    }

    public void setReference(BeanDefinition reference) {
        this.reference = reference;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BeanReferencePropertySetter)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BeanReferencePropertySetter that = (BeanReferencePropertySetter)o;
        return this.required == that.required && Objects.equals(this.referenceName, that.referenceName) && Objects.equals(this.referenceClass, that.referenceClass);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.referenceName, this.required, this.referenceClass);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n\t\"referenceName\":\"");
        builder.append(this.referenceName);
        builder.append("\",\n\t\"required\":\"");
        builder.append(this.required);
        builder.append("\",\n\t\"referenceClass\":\"");
        builder.append(this.referenceClass);
        builder.append("\",\n\t\"field\":\"");
        builder.append(this.field);
        builder.append("\",\n\t\"prototype\":\"");
        builder.append(this.isPrototype());
        builder.append("\"\n}");
        return builder.toString();
    }
}

