/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.factory.BeansException;
import cn.taketoday.context.factory.ObjectSupplier;
import cn.taketoday.context.utils.OrderUtils;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class DefaultObjectSupplier<T>
implements ObjectSupplier<T> {
    final Class<T> requiredType;
    final BeanFactory beanFactory;

    public DefaultObjectSupplier(Class<?> requiredType, BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.requiredType = requiredType;
    }

    @Override
    public T getIfAvailable() throws BeansException {
        return this.beanFactory.getBean(this.requiredType);
    }

    @Override
    public Class<?> getRequiredType() {
        return this.requiredType;
    }

    @Override
    public Stream<T> stream() {
        return this.beanFactory.getBeans(this.requiredType).stream();
    }

    @Override
    public Stream<T> orderedStream() {
        List<T> beans = OrderUtils.reversedSort(this.beanFactory.getBeans(this.requiredType));
        return beans.stream();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultObjectSupplier)) {
            return false;
        }
        DefaultObjectSupplier that = (DefaultObjectSupplier)o;
        return Objects.equals(this.requiredType, that.requiredType) && Objects.equals(this.beanFactory, that.beanFactory);
    }

    public int hashCode() {
        return Objects.hash(this.requiredType, this.beanFactory);
    }

    public String toString() {
        return "DefaultObjectSupplier{requiredType=" + this.requiredType + ", beanFactory=" + this.beanFactory + '}';
    }
}

