/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.factory.AbstractBeanFactory;
import cn.taketoday.context.factory.AbstractPropertySetter;
import java.lang.reflect.Field;
import java.util.Objects;

public class DefaultPropertySetter
extends AbstractPropertySetter {
    private final Object value;

    public DefaultPropertySetter(Object value, Field field) {
        super(field);
        this.value = value;
    }

    public void doSetValue(Object bean) {
        this.accessor.set(bean, this.value);
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    protected Object resolveValue(AbstractBeanFactory beanFactory) {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultPropertySetter)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultPropertySetter that = (DefaultPropertySetter)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    public String toString() {
        return "{\"value\":\"" + this.value + "\",\"property\":\"" + this.field.getName() + "\",\"propertyClass\":\"" + this.field.getType() + "\",\"beanClass:\":\"" + this.field.getDeclaringClass() + "\"}";
    }
}

