/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.exception.NoSuchBeanDefinitionException;
import cn.taketoday.context.factory.BeansException;
import cn.taketoday.context.utils.GenericTypeResolver;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;

@FunctionalInterface
public interface ObjectSupplier<T>
extends Supplier<T>,
Iterable<T> {
    @Override
    default public T get() throws BeansException {
        T ret = this.getIfAvailable();
        if (ret == null) {
            throw new NoSuchBeanDefinitionException(this.getRequiredType());
        }
        return ret;
    }

    public T getIfAvailable() throws BeansException;

    default public T getIfAvailable(Supplier<T> defaultSupplier) throws BeansException {
        T dependency = this.getIfAvailable();
        return dependency != null ? dependency : defaultSupplier.get();
    }

    default public void ifAvailable(Consumer<T> dependencyConsumer) throws BeansException {
        T dependency = this.getIfAvailable();
        if (dependency != null) {
            dependencyConsumer.accept(dependency);
        }
    }

    default public Class<?> getRequiredType() {
        return GenericTypeResolver.resolveTypeArgument(this.getClass(), ObjectSupplier.class);
    }

    @Override
    default public Iterator<T> iterator() {
        return this.stream().iterator();
    }

    default public Stream<T> stream() {
        throw new UnsupportedOperationException("Multi element access not supported");
    }

    default public Stream<T> orderedStream() {
        throw new UnsupportedOperationException("Ordered element access not supported");
    }
}

