/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.factory.BeanDefinition;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.factory.DefaultBeanDefinition;
import cn.taketoday.context.reflect.BeanConstructor;
import cn.taketoday.context.reflect.MethodAccessor;
import cn.taketoday.context.reflect.MethodAccessorBeanConstructor;
import cn.taketoday.context.reflect.MethodInvoker;
import cn.taketoday.context.reflect.StaticMethodAccessorBeanConstructor;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ObjectUtils;
import cn.taketoday.context.utils.OrderUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StandardBeanDefinition
extends DefaultBeanDefinition
implements BeanDefinition {
    private String declaringName;
    private Method factoryMethod;

    public StandardBeanDefinition(String beanName, Class<?> beanClass) {
        super(beanName, beanClass);
    }

    public StandardBeanDefinition(String beanName, BeanDefinition childDef) {
        super(beanName, childDef);
    }

    public String getDeclaringName() {
        return this.declaringName;
    }

    public StandardBeanDefinition setDeclaringName(String declaringName) {
        this.declaringName = declaringName;
        return this;
    }

    @Override
    public int getOrder() {
        int order = super.getOrder();
        if (0 == order) {
            return OrderUtils.getOrder(this.getFactoryMethod());
        }
        return order + OrderUtils.getOrder(this.getFactoryMethod());
    }

    public Method getFactoryMethod() {
        return this.factoryMethod;
    }

    public StandardBeanDefinition setFactoryMethod(Method factoryMethod) {
        this.factoryMethod = factoryMethod;
        return this;
    }

    @Override
    public Executable getExecutable() {
        return this.obtainFactoryMethod();
    }

    @Override
    protected BeanConstructor<?> createConstructor(BeanFactory factory) {
        Method factoryMethod = this.obtainFactoryMethod();
        MethodInvoker methodInvoker = MethodInvoker.create(factoryMethod);
        if (Modifier.isStatic(factoryMethod.getModifiers())) {
            return new StaticMethodAccessorBeanConstructor(methodInvoker);
        }
        Object bean = factory.getBean(this.getDeclaringName());
        return new MethodAccessorBeanConstructor((MethodAccessor)methodInvoker, bean);
    }

    private Method obtainFactoryMethod() {
        Method factoryMethod = this.getFactoryMethod();
        Assert.notNull((Object)factoryMethod, "StandardBeanDefinition is not ready");
        return factoryMethod;
    }

    @Override
    public String toString() {
        return "{\n\t\"name\":\"" + this.getName() + "\",\n\t\"declaringName\":\"" + this.getDeclaringName() + "\",\n\t\"beanClass\":\"" + this.getBeanClass() + "\",\n\t\"scope\":\"" + this.getScope() + "\",\n\t\"factoryMethod\":\"" + this.getFactoryMethod() + "\",\n\t\"initMethods\":\"" + Arrays.toString(this.getInitMethods()) + "\",\n\t\"destroyMethods\":\"" + Arrays.toString(this.getDestroyMethods()) + "\",\n\t\"propertyValues\":\"" + Arrays.toString(this.getPropertySetters()) + "\",\n\t\"initialized\":\"" + this.isInitialized() + "\",\n\t\"factoryBean\":\"" + this.isFactoryBean() + "\",\n\t\"abstract\":\"" + this.isAbstract() + "\"\n}";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof StandardBeanDefinition) {
            boolean equals = super.equals(obj);
            if (!equals) {
                return false;
            }
            StandardBeanDefinition other = (StandardBeanDefinition)obj;
            return Objects.equals(this.declaringName, other.declaringName) && Objects.equals(this.factoryMethod, other.factoryMethod);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.declaringName, this.factoryMethod);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return ClassUtils.isAnnotationPresent(this.getFactoryMethod(), annotation) || super.isAnnotationPresent(annotation);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        T ret = ClassUtils.getAnnotation(annotationClass, this.getFactoryMethod());
        if (ret == null) {
            return super.getAnnotation(annotationClass);
        }
        return ret;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.mergeAnnotations(this.getFactoryMethod().getAnnotations(), super.getAnnotations());
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.mergeAnnotations(this.getFactoryMethod().getDeclaredAnnotations(), super.getDeclaredAnnotations());
    }

    protected Annotation[] mergeAnnotations(Annotation[] methodAnns, Annotation[] classAnns) {
        if (ObjectUtils.isEmpty(methodAnns)) {
            return classAnns;
        }
        if (ObjectUtils.isNotEmpty(classAnns)) {
            HashSet<Annotation> rets = new HashSet<Annotation>();
            Set clazz = Stream.of(methodAnns).map(Annotation::annotationType).collect(Collectors.toSet());
            Collections.addAll(rets, methodAnns);
            for (Annotation annotation : classAnns) {
                if (clazz.contains(annotation.annotationType())) continue;
                rets.add(annotation);
            }
            return rets.toArray(new Annotation[rets.size()]);
        }
        return methodAnns;
    }
}

