/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.AnnotationAttributes;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.BeanNameCreator;
import cn.taketoday.context.ConfigurableApplicationContext;
import cn.taketoday.context.Constant;
import cn.taketoday.context.annotation.Component;
import cn.taketoday.context.annotation.ComponentScan;
import cn.taketoday.context.annotation.Configuration;
import cn.taketoday.context.annotation.IgnoreDuplicates;
import cn.taketoday.context.annotation.Import;
import cn.taketoday.context.annotation.Lazy;
import cn.taketoday.context.annotation.MissingBean;
import cn.taketoday.context.aware.ApplicationContextAware;
import cn.taketoday.context.aware.EnvironmentAware;
import cn.taketoday.context.aware.ImportAware;
import cn.taketoday.context.env.ConfigurableEnvironment;
import cn.taketoday.context.event.ApplicationListener;
import cn.taketoday.context.event.LoadingMissingBeanEvent;
import cn.taketoday.context.exception.BeanDefinitionStoreException;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.factory.AbstractBeanFactory;
import cn.taketoday.context.factory.BeanDefinition;
import cn.taketoday.context.factory.BeanDefinitionRegistry;
import cn.taketoday.context.factory.ConfigurableBeanFactory;
import cn.taketoday.context.factory.DefaultBeanDefinition;
import cn.taketoday.context.factory.FactoryBean;
import cn.taketoday.context.factory.FactoryBeanDefinition;
import cn.taketoday.context.factory.PropertySetter;
import cn.taketoday.context.factory.StandardBeanDefinition;
import cn.taketoday.context.loader.AutowiredPropertyResolver;
import cn.taketoday.context.loader.BeanDefinitionImporter;
import cn.taketoday.context.loader.BeanDefinitionLoader;
import cn.taketoday.context.loader.CandidateComponentScanner;
import cn.taketoday.context.loader.ImportSelector;
import cn.taketoday.context.loader.ObjectSupplierPropertyResolver;
import cn.taketoday.context.loader.PropertyValueResolver;
import cn.taketoday.context.loader.PropsPropertyResolver;
import cn.taketoday.context.loader.ValuePropertyResolver;
import cn.taketoday.context.logger.Logger;
import cn.taketoday.context.logger.LoggerFactory;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ContextUtils;
import cn.taketoday.context.utils.ExceptionUtils;
import cn.taketoday.context.utils.ObjectUtils;
import cn.taketoday.context.utils.OrderUtils;
import cn.taketoday.context.utils.ReflectionUtils;
import cn.taketoday.context.utils.StringUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

public class StandardBeanFactory
extends AbstractBeanFactory
implements ConfigurableBeanFactory,
BeanDefinitionLoader {
    private static final Logger log = LoggerFactory.getLogger(StandardBeanFactory.class);
    static final String MissingBeanMetadata = MissingBean.class.getName() + "-Metadata";
    static final String ImportAnnotatedMetadata = Import.class.getName() + "-Metadata";
    private final ConfigurableApplicationContext context;
    private final ArrayList<AnnotatedElement> componentScanned = new ArrayList();
    private final ArrayList<PropertyValueResolver> propertyResolvers = new ArrayList(4);
    private final HashSet<String> currentInitializingBeanName = new HashSet();

    public StandardBeanFactory(ConfigurableApplicationContext context) {
        Assert.notNull((Object)context, "applicationContext must not be null");
        this.context = context;
    }

    @Override
    protected void awareInternal(Object bean, BeanDefinition def) {
        Object attribute;
        super.awareInternal(bean, def);
        if (bean instanceof ApplicationContextAware) {
            ((ApplicationContextAware)bean).setApplicationContext(this.getApplicationContext());
        }
        if (bean instanceof EnvironmentAware) {
            ((EnvironmentAware)bean).setEnvironment(this.getApplicationContext().getEnvironment());
        }
        if (bean instanceof ImportAware && (attribute = def.getAttribute(ImportAnnotatedMetadata)) instanceof BeanDefinition) {
            ((ImportAware)bean).setImportBeanDefinition((BeanDefinition)attribute);
        }
    }

    @Override
    public Object initializeBean(Object bean, BeanDefinition def) {
        if (def.isPrototype()) {
            return super.initializeBean(bean, def);
        }
        String name = def.getName();
        if (this.currentInitializingBeanName.contains(name)) {
            return bean;
        }
        this.currentInitializingBeanName.add(name);
        Object initializingBean = super.initializeBean(bean, def);
        this.currentInitializingBeanName.remove(name);
        return initializingBean;
    }

    public void loadConfigurationBeans() {
        log.debug("Loading Configuration Beans");
        for (Map.Entry<String, BeanDefinition> entry : this.getBeanDefinitions().entrySet()) {
            if (!entry.getValue().isAnnotationPresent(Configuration.class)) continue;
            this.loadConfigurationBeans(entry.getValue());
        }
    }

    protected void loadConfigurationBeans(BeanDefinition declaringDef) {
        ConfigurableApplicationContext context = this.getApplicationContext();
        BeanNameCreator beanNameCreator = this.getBeanNameCreator();
        for (Method method : ReflectionUtils.getDeclaredMethods(declaringDef.getBeanClass())) {
            Object[] components = ClassUtils.getAnnotationAttributesArray(method, Component.class);
            if (ObjectUtils.isEmpty(components)) {
                AnnotationAttributes attributes = ClassUtils.getAnnotationAttributes(MissingBean.class, method);
                if (!this.isMissedBean(attributes, method, context)) continue;
                Class<?> beanClass = method.getReturnType();
                String name = attributes.getString("value");
                if (StringUtils.isEmpty(name)) {
                    name = method.getName();
                }
                StandardBeanDefinition stdDef = new StandardBeanDefinition(name, beanClass).setFactoryMethod(method).setDeclaringName(beanNameCreator.create(method.getDeclaringClass()));
                this.registerMissingBean(attributes, stdDef);
                if (!stdDef.isAnnotationPresent(Configuration.class)) continue;
                this.loadConfigurationBeans(stdDef);
                continue;
            }
            if (!ContextUtils.passCondition(method, context)) continue;
            this.registerConfigurationBean(declaringDef, method, (AnnotationAttributes[])components);
        }
    }

    protected void registerConfigurationBean(BeanDefinition declaringDef, Method method, AnnotationAttributes[] components) {
        Class<?> returnType = method.getReturnType();
        ConfigurableEnvironment environment = this.getApplicationContext().getEnvironment();
        Properties properties = environment.getProperties();
        String defaultBeanName = method.getName();
        String declaringBeanName = declaringDef.getName();
        for (AnnotationAttributes component : components) {
            String scope = component.getString("scope");
            String[] initMethods = component.getStringArray("initMethods");
            String[] destroyMethods = component.getStringArray("destroyMethods");
            for (String name : ContextUtils.findNames(defaultBeanName, component.getStringArray("value"))) {
                StandardBeanDefinition stdDef = new StandardBeanDefinition(name, returnType);
                stdDef.setScope(scope);
                stdDef.setDestroyMethods(destroyMethods);
                stdDef.setInitMethods(ContextUtils.resolveInitMethod(initMethods, returnType));
                stdDef.setDeclaringName(declaringBeanName).setFactoryMethod(method);
                stdDef.addPropertySetter(ContextUtils.resolveProps((AnnotatedElement)stdDef, properties));
                this.register(name, stdDef);
                if (!stdDef.isAnnotationPresent(Configuration.class)) continue;
                this.loadConfigurationBeans(stdDef);
            }
        }
    }

    public void loadMissingBean(Collection<Class<?>> candidates) {
        log.debug("Loading lost beans");
        ConfigurableApplicationContext context = this.getApplicationContext();
        BeanNameCreator nameCreator = this.getBeanNameCreator();
        context.publishEvent(new LoadingMissingBeanEvent(context, candidates));
        for (Class<?> beanClass : candidates) {
            AnnotationAttributes attributes = ClassUtils.getAnnotationAttributes(MissingBean.class, beanClass);
            if (!this.isMissedBean(attributes, beanClass, context)) continue;
            String beanName = attributes.getString("value");
            if (StringUtils.isEmpty(beanName)) {
                beanName = nameCreator.create(beanClass);
            }
            DefaultBeanDefinition def = new DefaultBeanDefinition(beanName, beanClass);
            this.registerMissingBean(attributes, def);
        }
    }

    private boolean isMissedBean(AnnotationAttributes missingBean, AnnotatedElement annotated, ApplicationContext context) {
        if (missingBean != null && ContextUtils.passCondition(annotated, context)) {
            String beanName = missingBean.getString("value");
            if (StringUtils.isNotEmpty(beanName) && this.containsBeanDefinition(beanName)) {
                return false;
            }
            Class type = missingBean.getClass("type");
            if (type != Void.TYPE) {
                return !this.containsBeanDefinition(type, missingBean.getBoolean("equals"));
            }
            return !this.containsBeanDefinition(ContextUtils.getBeanClass(annotated));
        }
        return false;
    }

    protected void registerMissingBean(AnnotationAttributes missingBean, BeanDefinition def) {
        Class<?> beanClass = def.getBeanClass();
        def.setScope(missingBean.getString("scope")).setDestroyMethods(missingBean.getStringArray("destroyMethods")).setInitMethods(ContextUtils.resolveInitMethod(missingBean.getStringArray("initMethods"), beanClass)).setPropertyValues(this.resolvePropertyValue(beanClass));
        def.setAttribute(MissingBeanMetadata, missingBean);
        ContextUtils.resolveProps(def, this.getApplicationContext().getEnvironment());
        this.register(def.getName(), def);
    }

    public Set<Class<?>> loadMetaInfoBeans() {
        log.debug("Loading META-INF/beans");
        ConfigurableApplicationContext context = this.getApplicationContext();
        Set<Class<?>> beans = ContextUtils.loadFromMetaInfo("META-INF/beans");
        BeanNameCreator beanNameCreator = this.getBeanNameCreator();
        for (Class<?> beanClass : beans) {
            AnnotationAttributes missingBean = ClassUtils.getAnnotationAttributes(MissingBean.class, beanClass);
            if (missingBean != null) {
                if (this.isMissedBean(missingBean, beanClass, context)) {
                    BeanDefinition def = this.createBeanDefinition(beanClass);
                    String name = missingBean.getString("value");
                    if (StringUtils.isNotEmpty(name)) {
                        def.setName(name);
                    }
                    this.registerMissingBean(missingBean, def);
                    continue;
                }
                log.info("@MissingBean -> '{}' cannot pass the condition or contains its bean definition, dont register to the map", (Object)beanClass);
                continue;
            }
            if (!ContextUtils.passCondition(beanClass, context)) continue;
            List<BeanDefinition> defs = ContextUtils.createBeanDefinitions(beanNameCreator.create(beanClass), beanClass, this);
            for (BeanDefinition def : defs) {
                this.register(def);
            }
        }
        return beans;
    }

    @Override
    public void importBeans(Class<?> ... beans) {
        for (Class<?> bean : Objects.requireNonNull(beans)) {
            BeanDefinition def = this.createBeanDefinition(bean);
            this.importAnnotated(def);
            this.register(def);
            this.loadConfigurationBeans(def);
        }
    }

    @Override
    public void importBeans(Set<BeanDefinition> defs) {
        for (BeanDefinition def : defs) {
            this.importAnnotated(def);
        }
    }

    @Override
    public void importAnnotated(BeanDefinition annotated) {
        for (AnnotationAttributes attr : ClassUtils.getAnnotationAttributesArray(annotated, Import.class)) {
            for (Class importClass : attr.getAttribute("value", Class[].class)) {
                if (this.containsBeanDefinition(importClass, true)) continue;
                this.doImport(annotated, importClass);
            }
        }
    }

    protected void doImport(BeanDefinition annotated, Class<?> importClass) {
        String[] imports;
        log.debug("Importing: [{}]", (Object)importClass);
        BeanDefinition importDef = this.createBeanDefinition(importClass);
        importDef.setAttribute(ImportAnnotatedMetadata, annotated);
        this.register(importDef);
        this.loadConfigurationBeans(importDef);
        if (ImportSelector.class.isAssignableFrom(importClass) && StringUtils.isArrayNotEmpty(imports = this.createImporter(importDef, ImportSelector.class).selectImports(annotated))) {
            for (String select : imports) {
                Class beanClass = ClassUtils.loadClass(select);
                if (beanClass == null) {
                    throw new ConfigurationException("Bean class not in class-path: " + select);
                }
                this.register(this.createBeanDefinition(beanClass));
            }
        }
        if (BeanDefinitionImporter.class.isAssignableFrom(importClass)) {
            this.createImporter(importDef, BeanDefinitionImporter.class).registerBeanDefinitions(annotated, this);
        }
        if (ApplicationListener.class.isAssignableFrom(importClass)) {
            this.getApplicationContext().addApplicationListener(this.createImporter(importDef, ApplicationListener.class));
        }
    }

    protected <T> T createImporter(BeanDefinition importDef, Class<T> target) {
        try {
            Object bean = this.getBean(importDef);
            if (bean instanceof ImportAware) {
                ((ImportAware)bean).setImportBeanDefinition(importDef);
            }
            return target.cast(bean);
        }
        catch (Throwable e) {
            throw new BeanDefinitionStoreException("Can't initialize a target: [" + importDef + "]");
        }
    }

    @Override
    protected BeanNameCreator createBeanNameCreator() {
        return this.getApplicationContext().getEnvironment().getBeanNameCreator();
    }

    @Override
    public final BeanDefinitionLoader getBeanDefinitionLoader() {
        return this;
    }

    @Override
    public void loadBeanDefinition(Class<?> candidate) {
        if (!Modifier.isAbstract(candidate.getModifiers()) && ContextUtils.passCondition(candidate, this.context)) {
            this.register(candidate);
        }
    }

    @Override
    public void loadBeanDefinitions(Collection<Class<?>> candidates) {
        for (Class<?> clazz : candidates) {
            this.loadBeanDefinition(clazz);
        }
    }

    @Override
    public void loadBeanDefinition(String name, Class<?> beanClass) {
        Object[] annotationAttributes = ClassUtils.getAnnotationAttributesArray(beanClass, Component.class);
        if (ObjectUtils.isEmpty(annotationAttributes)) {
            this.register(name, this.createBeanDefinition(name, beanClass, null));
        } else {
            for (Object attributes : annotationAttributes) {
                this.register(name, this.createBeanDefinition(name, beanClass, (AnnotationAttributes)attributes));
            }
        }
    }

    @Override
    public void loadBeanDefinition(String ... locations) {
        this.loadBeanDefinitions(new CandidateComponentScanner().scan(locations));
    }

    @Override
    public void register(Class<?> candidate) {
        Object[] annotationAttributes = ClassUtils.getAnnotationAttributesArray(candidate, Component.class);
        if (ObjectUtils.isNotEmpty(annotationAttributes)) {
            String defaultBeanName = this.getBeanNameCreator().create(candidate);
            for (Object attributes : annotationAttributes) {
                for (String name : ContextUtils.findNames(defaultBeanName, ((AnnotationAttributes)attributes).getStringArray("value"))) {
                    this.register(name, this.createBeanDefinition(name, candidate, (AnnotationAttributes)attributes));
                }
            }
        }
    }

    @Override
    public void register(String name, BeanDefinition def) {
        if ((def = this.transformBeanDefinition(name, def)) == null) {
            return;
        }
        ContextUtils.validateBeanDefinition(def);
        String nameToUse = name;
        Class<?> beanClass = def.getBeanClass();
        if (this.containsBeanDefinition(name) && !def.hasAttribute(MissingBeanMetadata)) {
            BeanDefinition existBeanDef = this.getBeanDefinition(name);
            Class<?> existClass = existBeanDef.getBeanClass();
            if (beanClass == existClass && existBeanDef.isAnnotationPresent(IgnoreDuplicates.class)) {
                return;
            }
            log.info("=====================|repeat bean definition START|=====================");
            log.info("There is already a bean called: [{}], its bean definition: [{}].", (Object)name, (Object)existBeanDef);
            if (beanClass == existClass) {
                log.warn("They have same bean class: [{}]. We will override it.", (Object)beanClass);
            } else {
                nameToUse = beanClass.getName();
                def.setName(nameToUse);
                log.warn("Current bean class: [{}]. You are supposed to change your bean name creator or bean name.", (Object)beanClass);
                log.warn("Current bean definition: [{}] will be registed as: [{}].", (Object)def, (Object)nameToUse);
            }
            log.info("======================|END|======================");
        }
        try {
            if (FactoryBean.class.isAssignableFrom(beanClass)) {
                this.registerFactoryBean(nameToUse, def);
            } else {
                this.registerBeanDefinition(nameToUse, def);
            }
        }
        catch (Throwable ex) {
            ex = ExceptionUtils.unwrapThrowable(ex);
            throw new BeanDefinitionStoreException("An Exception Occurred When Register Bean Definition: [" + def + "]", ex);
        }
    }

    protected BeanDefinition transformBeanDefinition(String name, BeanDefinition def) {
        Class<?> beanClass = def.getBeanClass();
        BeanDefinition missedDef = null;
        if (this.containsBeanDefinition(name)) {
            missedDef = this.getBeanDefinition(name);
        } else if (this.containsBeanDefinition(beanClass)) {
            missedDef = this.getBeanDefinition(beanClass);
        }
        if (missedDef != null && missedDef.hasAttribute(MissingBeanMetadata)) {
            def.copy(missedDef);
            def.setName(name);
        }
        return def;
    }

    @Override
    protected void postProcessRegisterBeanDefinition(BeanDefinition targetDef) {
        Object listener;
        super.postProcessRegisterBeanDefinition(targetDef);
        if (targetDef.isAnnotationPresent(Import.class)) {
            this.importAnnotated(targetDef);
        }
        if (targetDef.isAnnotationPresent(ComponentScan.class)) {
            this.componentScan(targetDef);
        }
        if (ApplicationListener.class.isAssignableFrom(targetDef.getBeanClass()) && (listener = this.getSingleton(targetDef.getName())) == null) {
            listener = this.createBeanIfNecessary(targetDef);
            this.context.addApplicationListener((ApplicationListener)listener);
        }
        this.applyLazyInit(targetDef);
    }

    protected void applyLazyInit(BeanDefinition def) {
        Lazy lazy = def.getAnnotation(Lazy.class);
        if (lazy != null) {
            def.setLazyInit(lazy.value());
        }
    }

    protected void componentScan(AnnotatedElement source) {
        if (!this.componentScanned.contains(source)) {
            this.componentScanned.add(source);
            for (AnnotationAttributes attribute : ClassUtils.getAnnotationAttributesArray(source, ComponentScan.class)) {
                this.loadBeanDefinition(attribute.getStringArray("value"));
            }
        }
    }

    protected void registerFactoryBean(String oldBeanName, BeanDefinition factoryDef) {
        FactoryBeanDefinition def = factoryDef instanceof FactoryBeanDefinition ? (FactoryBeanDefinition)factoryDef : new FactoryBeanDefinition(factoryDef, this);
        this.registerBeanDefinition(oldBeanName, def);
    }

    @Override
    public BeanDefinitionRegistry getRegistry() {
        return this;
    }

    @Override
    public BeanDefinition createBeanDefinition(Class<?> beanClass) {
        return this.createBeanDefinition(this.getBeanNameCreator().create(beanClass), beanClass, ClassUtils.getAnnotationAttributes(Component.class, beanClass));
    }

    @Override
    public BeanDefinition createBeanDefinition(String beanName, Class<?> beanClass, AnnotationAttributes attributes) {
        DefaultBeanDefinition ret = new DefaultBeanDefinition(beanName, beanClass);
        if (attributes == null) {
            ret.setDestroyMethods(Constant.EMPTY_STRING_ARRAY).setInitMethods(ContextUtils.resolveInitMethod(null, beanClass));
        } else {
            ret.setScope(attributes.getString("scope")).setDestroyMethods(attributes.getStringArray("destroyMethods")).setInitMethods(ContextUtils.resolveInitMethod(attributes.getStringArray("initMethods"), beanClass));
        }
        ret.setPropertyValues(this.resolvePropertyValue(beanClass));
        ContextUtils.resolveProps(ret, this.getApplicationContext().getEnvironment());
        return ret;
    }

    @Override
    public ConfigurableApplicationContext getApplicationContext() {
        return this.context;
    }

    public PropertySetter[] resolvePropertyValue(Class<?> beanClass) {
        LinkedHashSet<PropertySetter> propertySetters = new LinkedHashSet<PropertySetter>(32);
        for (Field field : ReflectionUtils.getFields(beanClass)) {
            PropertySetter created = this.createPropertyValue(ReflectionUtils.makeAccessible(field));
            if (created == null) continue;
            propertySetters.add(created);
        }
        return propertySetters.isEmpty() ? BeanDefinition.EMPTY_PROPERTY_VALUE : propertySetters.toArray(new PropertySetter[propertySetters.size()]);
    }

    public PropertySetter createPropertyValue(Field field) {
        for (PropertyValueResolver propertyValueResolver : this.getPropertyValueResolvers()) {
            if (!propertyValueResolver.supportsProperty(field)) continue;
            return propertyValueResolver.resolveProperty(field);
        }
        return null;
    }

    public ArrayList<PropertyValueResolver> getPropertyValueResolvers() {
        if (this.propertyResolvers.isEmpty()) {
            ConfigurableApplicationContext context = this.getApplicationContext();
            Set objects = ContextUtils.loadBeansFromMetaInfo("META-INF/property-resolvers", this);
            this.propertyResolvers.addAll(objects);
            this.addPropertyValueResolvers(new ValuePropertyResolver(context), new PropsPropertyResolver(context), new ObjectSupplierPropertyResolver(), new AutowiredPropertyResolver(context));
        }
        return this.propertyResolvers;
    }

    public void setPropertyValueResolvers(PropertyValueResolver ... resolvers) {
        Assert.notNull((Object)resolvers, "PropertyValueResolver must not be null");
        this.propertyResolvers.clear();
        Collections.addAll(this.propertyResolvers, OrderUtils.reversedSort(resolvers));
    }

    public void addPropertyValueResolvers(PropertyValueResolver ... resolvers) {
        if (ObjectUtils.isNotEmpty(resolvers)) {
            Collections.addAll(this.propertyResolvers, resolvers);
            OrderUtils.reversedSort(this.propertyResolvers);
        }
    }
}

