/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.io;

import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.io.FileBasedResource;
import cn.taketoday.context.io.Resource;
import cn.taketoday.context.io.ResourceFilter;
import cn.taketoday.context.io.Writable;
import cn.taketoday.context.io.WritableResource;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ResourceUtils;
import cn.taketoday.context.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;

public class ClassPathResource
implements Resource,
WritableResource {
    private final String location;
    private Class<?> resourceClass;
    private ClassLoader classLoader;
    private Resource resource;

    public ClassPathResource(String location) {
        this(location, ClassUtils.getClassLoader());
    }

    public ClassPathResource(String path, ClassLoader classLoader) {
        Assert.notNull((Object)path, "Path must not be null");
        String pathToUse = StringUtils.cleanPath(path);
        if (pathToUse.startsWith("/")) {
            pathToUse = pathToUse.substring(1);
        }
        this.location = pathToUse;
        this.classLoader = classLoader != null ? classLoader : ClassUtils.getClassLoader();
    }

    public ClassPathResource(String path, Class<?> clazz) {
        Assert.notNull((Object)path, "Path must not be null");
        this.location = StringUtils.cleanPath(path);
        this.resourceClass = clazz;
    }

    Resource getResource() {
        if (this.resource == null) {
            URL url = this.resourceClass != null ? this.resourceClass.getResource(this.location) : (this.classLoader != null ? this.classLoader.getResource(this.location) : ClassLoader.getSystemResource(this.location));
            this.resource = url != null ? ResourceUtils.getResource(url) : new FileBasedResource(this.location);
        }
        return this.resource;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getResource().getInputStream();
    }

    @Override
    public long contentLength() throws IOException {
        return this.getResource().contentLength();
    }

    @Override
    public String getName() {
        return StringUtils.getFilename(this.location);
    }

    @Override
    public long lastModified() throws IOException {
        return this.getResource().lastModified();
    }

    @Override
    public URL getLocation() throws IOException {
        return this.getResource().getLocation();
    }

    @Override
    public File getFile() throws IOException {
        return this.getResource().getFile();
    }

    @Override
    public boolean exists() {
        return this.getResource().exists();
    }

    @Override
    public boolean isDirectory() throws IOException {
        return this.getResource().isDirectory();
    }

    @Override
    public String[] list() throws IOException {
        return this.getResource().list();
    }

    @Override
    public Resource createRelative(String relativePath) throws IOException {
        String pathToUse = ResourceUtils.getRelativePath(this.location, relativePath);
        return this.resourceClass != null ? new ClassPathResource(pathToUse, this.resourceClass) : new ClassPathResource(pathToUse, this.classLoader);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        Resource resource = this.getResource();
        if (resource instanceof Writable) {
            return ((Writable)((Object)resource)).getOutputStream();
        }
        throw new IOException("Writable operation is not supported");
    }

    @Override
    public ReadableByteChannel readableChannel() throws IOException {
        return this.getResource().readableChannel();
    }

    @Override
    public WritableByteChannel writableChannel() throws IOException {
        Resource resource = this.getResource();
        if (resource instanceof Writable) {
            return ((Writable)((Object)resource)).writableChannel();
        }
        throw new ConfigurationException("Writable operation is not supported");
    }

    @Override
    public Resource[] list(ResourceFilter filter) throws IOException {
        return this.getResource().list(filter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassPathResource)) {
            return false;
        }
        ClassPathResource that = (ClassPathResource)o;
        return Objects.equals(this.location, that.location) && Objects.equals(this.resourceClass, that.resourceClass) && Objects.equals(this.classLoader, that.classLoader);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.resourceClass, this.classLoader);
    }

    public final Resource getOriginalResource() {
        return this.getResource();
    }

    @Override
    public URI getURI() throws IOException {
        return this.getResource().getURI();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("class path resource [");
        String pathToUse = this.location;
        if (this.resourceClass != null && !pathToUse.startsWith("/")) {
            builder.append(ClassUtils.classPackageAsResourcePath(this.resourceClass));
            builder.append('/');
        }
        if (pathToUse.startsWith("/")) {
            pathToUse = pathToUse.substring(1);
        }
        builder.append(pathToUse);
        builder.append(']');
        return builder.toString();
    }
}

