/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

@FunctionalInterface
public interface Readable {
    public InputStream getInputStream() throws IOException;

    default public Reader getReader() throws IOException {
        return this.getReader("UTF-8");
    }

    default public Reader getReader(String encoding) throws IOException {
        return new InputStreamReader(this.getInputStream(), encoding);
    }

    default public ReadableByteChannel readableChannel() throws IOException {
        return Channels.newChannel(this.getInputStream());
    }
}

