/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.loader;

import cn.taketoday.context.OrderedSupport;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.loader.ExecutableParameterResolver;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.CollectionUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Parameter;
import java.util.Map;

public class ArrayParameterResolver
extends OrderedSupport
implements ExecutableParameterResolver {
    public ArrayParameterResolver() {
        this(Integer.MAX_VALUE);
    }

    public ArrayParameterResolver(int order) {
        super(order);
    }

    @Override
    public boolean supports(Parameter parameter) {
        Class<?> type = parameter.getType();
        return type.isArray() && !ClassUtils.isSimpleType(type.getComponentType());
    }

    @Override
    public Object resolve(Parameter parameter, BeanFactory beanFactory) {
        Class<?> parameterType = parameter.getType().getComponentType();
        Map<String, ?> beans = beanFactory.getBeansOfType(parameterType);
        if (CollectionUtils.isEmpty(beans)) {
            return Array.newInstance(parameterType, 0);
        }
        return beans.values().toArray();
    }
}

