/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.loader;

import cn.taketoday.context.Ordered;
import cn.taketoday.context.OrderedSupport;
import cn.taketoday.context.annotation.Autowired;
import cn.taketoday.context.annotation.Props;
import cn.taketoday.context.annotation.Required;
import cn.taketoday.context.exception.NoSuchBeanDefinitionException;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.loader.ExecutableParameterResolver;
import cn.taketoday.context.logger.LoggerFactory;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ContextUtils;
import cn.taketoday.context.utils.StringUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;

public class AutowiredParameterResolver
extends OrderedSupport
implements ExecutableParameterResolver,
Ordered {
    public AutowiredParameterResolver() {
        this(0);
    }

    public AutowiredParameterResolver(int order) {
        super(order);
    }

    @Override
    public boolean supports(Parameter parameter) {
        return true;
    }

    @Override
    public final Object resolve(Parameter parameter, BeanFactory beanFactory) {
        Autowired autowired = parameter.getAnnotation(Autowired.class);
        Object bean = this.resolveBean(autowired != null ? autowired.value() : null, parameter.getType(), beanFactory);
        if (parameter.isAnnotationPresent(Props.class)) {
            bean = this.resolvePropsInternal(parameter, parameter.getAnnotation(Props.class), bean);
        }
        if (bean == null && AutowiredParameterResolver.isRequired(parameter, autowired)) {
            NoSuchBeanDefinitionException noSuchBean = new NoSuchBeanDefinitionException(parameter.getType());
            LoggerFactory.getLogger(AutowiredParameterResolver.class).error("[{}] on executable: [{}] is required and there isn't a [{}] bean", parameter, parameter.getDeclaringExecutable(), parameter.getType(), noSuchBean);
            throw noSuchBean;
        }
        return bean;
    }

    static boolean isRequired(AnnotatedElement element, Autowired autowired) {
        return autowired == null || autowired.required() || ClassUtils.isAnnotationPresent(element, Required.class);
    }

    protected Object resolveBean(String name, Class<?> type, BeanFactory beanFactory) {
        if (StringUtils.isNotEmpty(name)) {
            return beanFactory.getBean(name, type);
        }
        return beanFactory.getBean(type);
    }

    protected Object resolvePropsInternal(Parameter parameter, Props props, Object bean) {
        if (bean != null) {
            return ContextUtils.resolveProps(props, bean, ContextUtils.loadProps(props, System.getProperties()));
        }
        return ContextUtils.resolveProps(props, parameter.getType(), ContextUtils.loadProps(props, System.getProperties()));
    }
}

