/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.loader;

import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.annotation.Autowired;
import cn.taketoday.context.aware.OrderedApplicationContextSupport;
import cn.taketoday.context.factory.BeanDefinition;
import cn.taketoday.context.factory.BeanReferencePropertySetter;
import cn.taketoday.context.factory.PropertySetter;
import cn.taketoday.context.loader.AutowiredParameterResolver;
import cn.taketoday.context.loader.PropertyValueResolver;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Map;

public class AutowiredPropertyResolver
extends OrderedApplicationContextSupport
implements PropertyValueResolver {
    private static final Class<? extends Annotation> NAMED_CLASS = ClassUtils.loadClass("javax.inject.Named");
    private static final Class<? extends Annotation> INJECT_CLASS = ClassUtils.loadClass("javax.inject.Inject");
    private static final Class<? extends Annotation> RESOURCE_CLASS = ClassUtils.loadClass("javax.annotation.Resource");

    public AutowiredPropertyResolver(ApplicationContext context) {
        this(context, 0x3FFFFFFF);
    }

    public AutowiredPropertyResolver(ApplicationContext context, int order) {
        super(order);
        this.setApplicationContext(context);
    }

    @Override
    public boolean supportsProperty(Field field) {
        return AutowiredPropertyResolver.isInjectable(field);
    }

    public static boolean isInjectable(AnnotatedElement element) {
        return ClassUtils.isAnnotationPresent(element, Autowired.class) || ClassUtils.isAnnotationPresent(element, RESOURCE_CLASS) || ClassUtils.isAnnotationPresent(element, NAMED_CLASS) || ClassUtils.isAnnotationPresent(element, INJECT_CLASS);
    }

    @Override
    public PropertySetter resolveProperty(Field field) {
        Autowired autowired = field.getAnnotation(Autowired.class);
        String name = null;
        Class<?> propertyClass = field.getType();
        if (autowired != null) {
            name = autowired.value();
        } else if (ClassUtils.isAnnotationPresent(field, RESOURCE_CLASS)) {
            name = ClassUtils.getAnnotationAttributes(RESOURCE_CLASS, field).getString("name");
        } else if (ClassUtils.isAnnotationPresent(field, NAMED_CLASS)) {
            name = ClassUtils.getAnnotationAttributes(NAMED_CLASS, field).getString("value");
        }
        if (StringUtils.isEmpty(name)) {
            name = this.byType(propertyClass);
        }
        boolean required = AutowiredParameterResolver.isRequired(field, autowired);
        return new BeanReferencePropertySetter(name, required, field);
    }

    protected String byType(Class<?> targetClass) {
        String name;
        ApplicationContext context = this.obtainApplicationContext();
        if (context.hasStarted() && StringUtils.isNotEmpty(name = this.findName(context, targetClass))) {
            return name;
        }
        return context.getEnvironment().getBeanNameCreator().create(targetClass);
    }

    protected String findName(ApplicationContext applicationContext, Class<?> propertyClass) {
        for (Map.Entry<String, BeanDefinition> entry : applicationContext.getBeanDefinitions().entrySet()) {
            if (!propertyClass.isAssignableFrom(entry.getValue().getBeanClass())) continue;
            return entry.getKey();
        }
        return null;
    }
}

