/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.loader;

import cn.taketoday.context.Constant;
import cn.taketoday.context.ThrowableSupplier;
import cn.taketoday.context.exception.ContextException;
import cn.taketoday.context.io.FileBasedResource;
import cn.taketoday.context.io.JarEntryResource;
import cn.taketoday.context.io.Resource;
import cn.taketoday.context.io.ResourceFilter;
import cn.taketoday.context.logger.Logger;
import cn.taketoday.context.logger.LoggerFactory;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ResourceUtils;
import cn.taketoday.context.utils.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;

public class CandidateComponentScanner {
    private static final Logger log = LoggerFactory.getLogger(CandidateComponentScanner.class);
    private Set<Class<?>> candidates;
    private String[] ignoreScanJarPrefixs;
    private int initialCandidatesCapacity = 512;
    private Predicate<Resource> jarResourceFilter;
    private static String[] defaultIgnoreScanJarPrefixs;
    private boolean useDefaultIgnoreScanJarPrefix = true;
    private ClassLoader classLoader = ClassUtils.getClassLoader();
    private int scanningTimes = 0;
    private static CandidateComponentScanner sharedScanner;
    private static final ResourceFilter CLASS_RESOURCE_FILTER;

    public static String[] getDefaultIgnoreJarPrefix() {
        if (defaultIgnoreScanJarPrefixs != null) {
            return defaultIgnoreScanJarPrefixs;
        }
        log.info("Loading 'META-INF/ignore/jar-prefix'");
        HashSet<String> ignoreScanJars = new HashSet<String>(64);
        try {
            Enumeration<URL> resources = ClassUtils.getClassLoader().getResources("META-INF/ignore/jar-prefix");
            Charset charset = Constant.DEFAULT_CHARSET;
            while (resources.hasMoreElements()) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(resources.nextElement().openStream(), charset));
                Throwable throwable = null;
                try {
                    String str;
                    while ((str = reader.readLine()) != null) {
                        if (!StringUtils.isNotEmpty(str)) continue;
                        ignoreScanJars.add(str);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            defaultIgnoreScanJarPrefixs = ignoreScanJars.toArray(new String[ignoreScanJars.size()]);
            return defaultIgnoreScanJarPrefixs;
        }
        catch (IOException e) {
            throw new ContextException("IOException occurred when load 'META-INF/ignore/jar-prefix'", e);
        }
    }

    public CandidateComponentScanner() {
    }

    public CandidateComponentScanner(int initialCapacity) {
        this.initialCandidatesCapacity = initialCapacity;
    }

    public CandidateComponentScanner(Set<Class<?>> candidates) {
        this.candidates = candidates;
    }

    public Set<Class<?>> getAnnotatedClasses(Class<? extends Annotation> annotationClass) {
        return this.filter(clazz -> clazz.isAnnotationPresent(annotationClass));
    }

    public Set<Class<?>> getImplementationClasses(Class<?> superClass) {
        return this.filter(clazz -> superClass.isAssignableFrom((Class<?>)clazz) && superClass != clazz);
    }

    public Set<Class<?>> getImplementationClasses(Class<?> superClass, String packageName) {
        return this.filter(clazz -> clazz.getName().startsWith(packageName) && superClass != clazz && superClass.isAssignableFrom((Class<?>)clazz));
    }

    public final Set<Class<?>> filter(Predicate<Class<?>> predicate) {
        return this.getScanningCandidates().parallelStream().filter(predicate).collect(Collectors.toSet());
    }

    public Set<Class<?>> getClasses(String ... packages) {
        return this.filter(clazz -> {
            String name = clazz.getName();
            for (String prefix : packages) {
                if (!StringUtils.isEmpty(prefix) && !name.startsWith(prefix)) continue;
                return true;
            }
            return false;
        });
    }

    public Set<Class<?>> scan(String ... packages) {
        Assert.notNull((Object)packages, "scan packages can't be null");
        if (packages.length == 1) {
            return this.scanOne(packages[0]);
        }
        HashSet<String> packagesToScan = new HashSet<String>(8);
        for (String location : packages) {
            if (StringUtils.isEmpty(location)) {
                return this.scan();
            }
            packagesToScan.add(location);
        }
        for (String location : packagesToScan) {
            this.scan(location);
        }
        return this.getScanningCandidates();
    }

    protected Set<Class<?>> scanOne(String location) {
        if (StringUtils.isEmpty(location)) {
            return this.scan();
        }
        return this.scan(location);
    }

    public Set<Class<?>> scan(String packageName) {
        String resourceToUse = packageName.replace('.', '/');
        if (log.isDebugEnabled()) {
            log.debug("Scanning component candidates from package: [{}]", (Object)packageName);
        }
        try {
            Enumeration<URL> uri = this.getClassLoader().getResources(resourceToUse);
            while (uri.hasMoreElements()) {
                this.scan(ResourceUtils.getResource(uri.nextElement()), packageName);
            }
            ++this.scanningTimes;
            return this.getScanningCandidates();
        }
        catch (IOException e) {
            throw new ContextException("IO exception occur With Msg: [" + e + ']', e);
        }
    }

    protected void scan(Resource resource, String packageName) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("Scanning candidate components in [{}]", (Object)resource.getLocation());
        }
        if (resource instanceof FileBasedResource) {
            if (resource.isDirectory()) {
                this.findInDirectory(resource);
                return;
            }
            if (resource.getName().endsWith(".jar")) {
                this.scanInJarFile(resource, packageName, () -> new JarFile(resource.getFile()));
            }
        } else if (resource instanceof JarEntryResource) {
            this.scanInJarFile(resource, packageName, ((JarEntryResource)resource)::getJarFile);
        }
    }

    protected void scanInJarFile(Resource resource, String packageName, ThrowableSupplier<JarFile, IOException> jarFileSupplier) throws IOException {
        if (this.getJarResourceFilter().test(resource)) {
            if (log.isTraceEnabled()) {
                log.trace("Scan in jar file: [{}]", (Object)resource.getLocation());
            }
            try (JarFile jarFile = jarFileSupplier.get();){
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    this.loadClassFromJarEntry(jarEntries.nextElement(), packageName);
                }
            }
        }
    }

    public Set<Class<?>> scan() {
        ClassLoader classLoader = this.getClassLoader();
        log.debug("Use ClassLoader [{}] to scan", (Object)classLoader);
        try {
            String blank = "";
            if (classLoader instanceof URLClassLoader) {
                for (URL url : ((URLClassLoader)classLoader).getURLs()) {
                    this.scan(ResourceUtils.getResource(url), "");
                }
            } else {
                URL resource = classLoader.getResource("");
                Assert.notNull((Object)resource, "Could't found class root path");
                this.scan(ResourceUtils.getResource(resource), "");
            }
            ++this.scanningTimes;
            return this.getScanningCandidates();
        }
        catch (IOException e) {
            throw new ContextException("IO exception occur When scan all the classpath classes, With Msg: [" + e + ']', e);
        }
    }

    public void loadClassFromJarEntry(JarEntry jarEntry, String packageName) {
        if (jarEntry.isDirectory()) {
            return;
        }
        String jarEntryName = jarEntry.getName();
        if (jarEntryName.endsWith(".class")) {
            String nameToUse = jarEntryName.replace('/', '.');
            if (StringUtils.isEmpty(packageName) || nameToUse.startsWith(packageName)) {
                try {
                    String className = nameToUse.substring(0, nameToUse.lastIndexOf(46));
                    this.getScanningCandidates().add(this.getClassLoader().loadClass(className));
                }
                catch (ClassNotFoundException | Error throwable) {
                    // empty catch block
                }
            }
        }
    }

    protected void findInDirectory(Resource directory) throws IOException {
        if (!directory.exists()) {
            log.error("The location: [{}] you provided that does not exist", (Object)directory.getLocation());
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Enter: [{}]", (Object)directory.getLocation());
        }
        ClassLoader classLoader = this.getClassLoader();
        Set<Class<?>> candidates = this.getScanningCandidates();
        for (Resource resource : directory.list(CLASS_RESOURCE_FILTER)) {
            if (resource.isDirectory()) {
                this.findInDirectory(resource);
                continue;
            }
            try {
                candidates.add(classLoader.loadClass(ClassUtils.getClassName(resource)));
            }
            catch (ClassNotFoundException | Error throwable) {
                // empty catch block
            }
        }
    }

    public void clear() {
        this.scanningTimes = 0;
        if (this.candidates != null) {
            this.candidates.clear();
        }
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader = this.classLoader;
        if (classLoader == null) {
            this.classLoader = ClassUtils.getClassLoader();
            return this.classLoader;
        }
        return classLoader;
    }

    public CandidateComponentScanner setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public Set<Class<?>> getCandidates() {
        return this.candidates;
    }

    public CandidateComponentScanner setCandidates(Set<Class<?>> candidates) {
        this.candidates = candidates;
        return this;
    }

    public final Set<Class<?>> getScanningCandidates() {
        Set<Class<?>> candidates = this.getCandidates();
        if (candidates == null) {
            this.candidates = new HashSet(this.initialCandidatesCapacity);
            return this.candidates;
        }
        return candidates;
    }

    public String[] getIgnoreScanJarPrefixs() {
        return this.ignoreScanJarPrefixs;
    }

    public CandidateComponentScanner setIgnoreScanJarPrefixs(String ... ignoreScanJarPrefixs) {
        this.ignoreScanJarPrefixs = ignoreScanJarPrefixs;
        return this;
    }

    public boolean isUseDefaultIgnoreScanJarPrefix() {
        return this.useDefaultIgnoreScanJarPrefix;
    }

    public CandidateComponentScanner setUseDefaultIgnoreScanJarPrefix(boolean useDefaultIgnoreScanJarPrefix) {
        this.useDefaultIgnoreScanJarPrefix = useDefaultIgnoreScanJarPrefix;
        return this;
    }

    public Predicate<Resource> getJarResourceFilter() {
        Predicate<Resource> jarResourceFilter = this.jarResourceFilter;
        if (jarResourceFilter == null) {
            this.jarResourceFilter = new DefaultJarResourcePredicate(this);
            return this.jarResourceFilter;
        }
        return jarResourceFilter;
    }

    public CandidateComponentScanner setJarResourceFilter(Predicate<Resource> jarResourceFilter) {
        this.jarResourceFilter = jarResourceFilter;
        return this;
    }

    public static CandidateComponentScanner getSharedInstance() {
        return sharedScanner;
    }

    public static void setSharedInstance(CandidateComponentScanner sharedScanner) {
        CandidateComponentScanner.sharedScanner = sharedScanner;
    }

    public int getInitialCandidatesCapacity() {
        return this.initialCandidatesCapacity;
    }

    public CandidateComponentScanner setInitialCandidatesCapacity(int initialCandidatesCapacity) {
        this.initialCandidatesCapacity = initialCandidatesCapacity;
        return this;
    }

    public final int getScanningTimes() {
        return this.scanningTimes;
    }

    static {
        sharedScanner = new CandidateComponentScanner();
        CLASS_RESOURCE_FILTER = resource -> resource.isDirectory() || resource.getName().endsWith(".class") && !resource.getName().startsWith("package-info");
    }

    static final class DefaultJarResourcePredicate
    implements Predicate<Resource> {
        private final CandidateComponentScanner scanner;

        DefaultJarResourcePredicate(CandidateComponentScanner scanner) {
            this.scanner = scanner;
        }

        @Override
        public boolean test(Resource resource) {
            String[] ignoreScanJarPrefixs;
            if (this.scanner.isUseDefaultIgnoreScanJarPrefix()) {
                String fileName = resource.getName();
                for (String ignoreJarName : CandidateComponentScanner.getDefaultIgnoreJarPrefix()) {
                    if (!fileName.startsWith(ignoreJarName)) continue;
                    return false;
                }
            }
            if ((ignoreScanJarPrefixs = this.scanner.getIgnoreScanJarPrefixs()) != null) {
                String fileName = resource.getName();
                for (String ignoreJarName : ignoreScanJarPrefixs) {
                    if (!fileName.startsWith(ignoreJarName)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

