/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.loader;

import cn.taketoday.context.Ordered;
import cn.taketoday.context.OrderedSupport;
import cn.taketoday.context.annotation.DefaultProps;
import cn.taketoday.context.annotation.Props;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.loader.ExecutableParameterResolver;
import cn.taketoday.context.utils.CollectionUtils;
import cn.taketoday.context.utils.ContextUtils;
import cn.taketoday.context.utils.ResolvableType;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.Properties;

public class MapParameterResolver
extends OrderedSupport
implements ExecutableParameterResolver,
Ordered {
    public MapParameterResolver() {
        this(Integer.MAX_VALUE);
    }

    public MapParameterResolver(int order) {
        super(order);
    }

    @Override
    public boolean supports(Parameter parameter) {
        return Map.class.isAssignableFrom(parameter.getType());
    }

    @Override
    public Object resolve(Parameter parameter, BeanFactory beanFactory) {
        Class<?> type = parameter.getType();
        Map beansOfType = this.getBeansOfType(parameter, beanFactory);
        return this.convert(beansOfType, type);
    }

    protected Map getBeansOfType(Parameter parameter, BeanFactory beanFactory) {
        Props props = this.getProps(parameter);
        if (props != null) {
            return ContextUtils.loadProps(props, System.getProperties());
        }
        ResolvableType parameterType = ResolvableType.forParameter(parameter);
        ResolvableType generic = parameterType.asMap().getGeneric(1);
        Class<?> beanClass = generic.toClass();
        return beanFactory.getBeansOfType(beanClass);
    }

    protected Map convert(Map map, Class<?> type) {
        if (type != Map.class) {
            Map newMap = CollectionUtils.createMap(type, map.size());
            newMap.putAll(map);
            map = newMap;
        }
        return map;
    }

    private Props getProps(Parameter parameter) {
        Props props = parameter.getAnnotation(Props.class);
        if (props == null && Properties.class.isAssignableFrom(parameter.getType())) {
            return new DefaultProps();
        }
        return props;
    }
}

