/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.loader;

import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.annotation.Props;
import cn.taketoday.context.aware.OrderedApplicationContextSupport;
import cn.taketoday.context.factory.DefaultPropertySetter;
import cn.taketoday.context.loader.PropertyValueResolver;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ContextUtils;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;

public class PropsPropertyResolver
extends OrderedApplicationContextSupport
implements PropertyValueResolver {
    public PropsPropertyResolver(ApplicationContext context) {
        this(context, 0x3FFFFFFD);
    }

    public PropsPropertyResolver(ApplicationContext context, int order) {
        super(order);
        this.setApplicationContext(context);
    }

    @Override
    public boolean supportsProperty(Field field) {
        return ClassUtils.isAnnotationPresent(field, Props.class);
    }

    @Override
    public DefaultPropertySetter resolveProperty(Field field) {
        Props props = ClassUtils.getAnnotation(Props.class, field);
        Properties properties = ContextUtils.loadProps(props, this.obtainApplicationContext().getEnvironment().getProperties());
        Class<?> propertyClass = field.getType();
        if (!Map.class.isAssignableFrom(propertyClass)) {
            return new DefaultPropertySetter(ContextUtils.resolveProps(props, propertyClass, properties), field);
        }
        return new DefaultPropertySetter(properties, field);
    }
}

