/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.logger;

import cn.taketoday.context.io.ClassPathResource;
import cn.taketoday.context.logger.JavaLoggingLogger;
import cn.taketoday.context.logger.LoggerFactory;
import java.io.IOException;
import java.util.logging.LogManager;

class JavaLoggingFactory
extends LoggerFactory {
    JavaLoggingFactory() {
    }

    @Override
    protected JavaLoggingLogger createLogger(String name) {
        return new JavaLoggingLogger(name);
    }

    static {
        ClassPathResource resource = new ClassPathResource("logging.properties", Thread.currentThread().getContextClassLoader());
        if (resource.exists()) {
            try {
                LogManager.getLogManager().readConfiguration(resource.getInputStream());
            }
            catch (IOException | SecurityException e) {
                System.err.println("Can't load config file \"" + resource + "\"");
                e.printStackTrace();
            }
        }
    }
}

