/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.logger;

import cn.taketoday.context.logger.AbstractLogger;
import cn.taketoday.context.logger.Level;
import cn.taketoday.context.logger.MessageFormatter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.LocationAwareLogger;
import org.apache.logging.log4j.util.StackLocatorUtil;

public class Log4j2Logger
extends AbstractLogger {
    private final Logger logger;

    public Log4j2Logger(String name) {
        this.logger = LogManager.getLogger((String)name);
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    protected org.apache.logging.log4j.Level getLevel(Level level) {
        switch (level) {
            case DEBUG: {
                return org.apache.logging.log4j.Level.DEBUG;
            }
            case WARN: {
                return org.apache.logging.log4j.Level.WARN;
            }
            case ERROR: 
            case TRACE: {
                return org.apache.logging.log4j.Level.ERROR;
            }
        }
        return org.apache.logging.log4j.Level.INFO;
    }

    @Override
    protected void logInternal(Level level, final String format, final Throwable t, final Object[] args) {
        Message message = new Message(){
            private static final long serialVersionUID = 1L;
            private String msg;

            public Throwable getThrowable() {
                return t;
            }

            public Object[] getParameters() {
                return args;
            }

            public String getFormattedMessage() {
                if (this.msg == null) {
                    this.msg = MessageFormatter.format(format, args);
                }
                return this.msg;
            }

            public String getFormat() {
                return this.msg;
            }
        };
        if (this.logger instanceof LocationAwareLogger) {
            ((LocationAwareLogger)this.logger).logMessage(this.getLevel(level), null, FQCN, StackLocatorUtil.calcLocation((String)FQCN), message, t);
        } else {
            this.logger.log(this.getLevel(level), message, t);
        }
    }
}

