/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.logger;

import cn.taketoday.context.logger.JavaLoggingFactory;
import cn.taketoday.context.logger.Log4j2LoggerFactory;
import cn.taketoday.context.logger.Logger;
import cn.taketoday.context.logger.Slf4jLoggerFactory;

public abstract class LoggerFactory {
    public static final String LOG_TYPE_SYSTEM_PROPERTY = "logger.factory";
    public static LoggerFactory factory;

    protected abstract Logger createLogger(String var1);

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String name) {
        if (factory == null) {
            Class<LoggerFactory> clazz = LoggerFactory.class;
            synchronized (LoggerFactory.class) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return LoggerFactory.fromFactory(name);
            }
        }
        return factory.createLogger(name);
    }

    private static Logger fromFactory(String name) {
        String type = System.getProperty(LOG_TYPE_SYSTEM_PROPERTY);
        if (type != null) {
            try {
                factory = (LoggerFactory)Class.forName(type).newInstance();
                return factory.createLogger(name);
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.err.println("Could not find valid log-type from system property 'logger.factory', value '" + type + "'");
            }
        }
        try {
            factory = new Slf4jLoggerFactory();
            return factory.createLogger(name);
        }
        catch (Throwable throwable) {
            try {
                factory = new Log4j2LoggerFactory();
                return factory.createLogger(name);
            }
            catch (Throwable throwable2) {
                factory = new JavaLoggingFactory();
                return factory.createLogger(name);
            }
        }
    }

    public static void setFactory(LoggerFactory loggerFactory) {
        factory = loggerFactory;
    }
}

