/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.logger;

import cn.taketoday.context.logger.AbstractLogger;
import cn.taketoday.context.logger.Level;
import cn.taketoday.context.logger.MessageFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLogger
extends AbstractLogger {
    private final Logger target;

    public Slf4jLogger(String className) {
        this.target = LoggerFactory.getLogger((String)className);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.target.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.target.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.target.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.target.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.target.isErrorEnabled();
    }

    @Override
    public String getName() {
        return this.target.getName();
    }

    @Override
    protected void logInternal(Level level, String format, Throwable t, Object[] args) {
        if (this.target instanceof LocationAwareLogger) {
            int i;
            switch (level) {
                case DEBUG: {
                    i = 10;
                    break;
                }
                case ERROR: {
                    i = 40;
                    break;
                }
                case TRACE: {
                    i = 0;
                    break;
                }
                case WARN: {
                    i = 30;
                    break;
                }
                default: {
                    i = 20;
                }
            }
            ((LocationAwareLogger)this.target).log(null, FQCN, i, format, args, t);
        } else {
            String msg = MessageFormatter.format(format, args);
            switch (level) {
                case DEBUG: {
                    this.target.debug(msg, t);
                    break;
                }
                case ERROR: {
                    this.target.error(msg, t);
                    break;
                }
                case TRACE: {
                    this.target.trace(msg, t);
                    break;
                }
                case WARN: {
                    this.target.warn(msg, t);
                    break;
                }
                default: {
                    this.target.info(msg, t);
                }
            }
        }
    }
}

