/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.reflect;

import cn.taketoday.context.asm.ClassVisitor;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.CglibReflectUtils;
import cn.taketoday.context.cglib.core.ClassEmitter;
import cn.taketoday.context.cglib.core.ClassGenerator;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.EmitUtils;
import cn.taketoday.context.cglib.core.MethodInfo;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.exception.ContextException;
import cn.taketoday.context.logger.LoggerFactory;
import cn.taketoday.context.reflect.ConstructorAccessor;
import cn.taketoday.context.reflect.ConstructorConstructorAccessor;
import cn.taketoday.context.reflect.GeneratorSupport;
import cn.taketoday.context.utils.Assert;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public class ConstructorAccessorGenerator
extends GeneratorSupport<ConstructorAccessor>
implements ClassGenerator {
    private final Constructor<?> targetConstructor;
    private static final String[] interfaces = new String[]{"Lcn/taketoday/context/reflect/ConstructorAccessor;"};
    private static final MethodInfo newInstanceInfo;

    public ConstructorAccessorGenerator(Constructor<?> constructor) {
        this(constructor, constructor.getDeclaringClass());
    }

    public ConstructorAccessorGenerator(Constructor<?> constructor, Class<?> targetClass) {
        super(targetClass);
        Assert.notNull(constructor, "constructor must not be null");
        this.targetConstructor = constructor;
    }

    @Override
    protected int getArgsIndex() {
        return 1;
    }

    @Override
    public void generateClass(ClassVisitor v) {
        ClassEmitter classEmitter = this.beginClass(v);
        CodeEmitter codeEmitter = EmitUtils.beginMethod(classEmitter, newInstanceInfo, 17);
        codeEmitter.new_instance(Type.getType(this.targetClass));
        codeEmitter.dup();
        this.prepareParameters(codeEmitter, this.targetConstructor);
        Type type = Type.getType(this.targetClass);
        Signature signature = new Signature(this.targetConstructor);
        codeEmitter.invoke_constructor(type, signature);
        codeEmitter.return_value();
        codeEmitter.end_method();
        classEmitter.endClass();
    }

    @Override
    protected ConstructorAccessor fallback(Exception exception) {
        LoggerFactory.getLogger(ConstructorAccessorGenerator.class).warn("Cannot access a Constructor: [{}]", (Object)this.targetConstructor, (Object)exception);
        return (ConstructorAccessor)super.fallback(exception);
    }

    @Override
    protected ConstructorAccessor fallbackInstance() {
        return new ConstructorConstructorAccessor(this.targetConstructor);
    }

    @Override
    protected boolean cannotAccess() {
        return Modifier.isPrivate(this.targetClass.getModifiers()) || Modifier.isPrivate(this.targetConstructor.getModifiers());
    }

    @Override
    protected ClassGenerator getClassGenerator() {
        return this;
    }

    @Override
    protected Object cacheKey() {
        return this.targetConstructor;
    }

    @Override
    protected String createClassName() {
        StringBuilder builder = new StringBuilder(this.targetClass.getName());
        builder.append('$').append("class");
        this.buildClassNameSuffix(builder, this.targetConstructor);
        return builder.toString();
    }

    @Override
    public String[] getInterfaces() {
        return interfaces;
    }

    static {
        try {
            newInstanceInfo = CglibReflectUtils.getMethodInfo(ConstructorAccessor.class.getDeclaredMethod("newInstance", Object[].class));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new ContextException(e);
        }
    }
}

