/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.reflect;

import cn.taketoday.context.reflect.ConstructorAccessor;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.CollectionUtils;

public class MapConstructor
implements ConstructorAccessor {
    private int capacity = 0;
    private Class<?> keyType;
    private final Class<?> mapType;

    public MapConstructor(Class<?> mapType) {
        this(mapType, null);
    }

    public MapConstructor(Class<?> mapType, Class<?> keyType) {
        Assert.notNull(mapType, "map type must not be null");
        this.keyType = keyType;
        this.mapType = mapType;
    }

    @Override
    public Object newInstance(Object[] args) {
        return CollectionUtils.createMap(this.mapType, this.keyType, this.capacity);
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setKeyType(Class<?> keyType) {
        this.keyType = keyType;
    }
}

