/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.reflect;

import cn.taketoday.context.reflect.MethodInvoker;
import cn.taketoday.context.reflect.PropertyAccessor;
import cn.taketoday.context.utils.Assert;
import java.lang.reflect.Method;

public final class MethodAccessorPropertyAccessor
implements PropertyAccessor {
    private final MethodInvoker readAccessor;
    private final MethodInvoker writeAccessor;

    public MethodAccessorPropertyAccessor(Method setMethod, Method getMethod) {
        Assert.notNull((Object)setMethod, "setMethod must not be null");
        Assert.notNull((Object)getMethod, "getMethod must not be null");
        this.readAccessor = MethodInvoker.create(getMethod);
        this.writeAccessor = MethodInvoker.create(setMethod);
    }

    @Override
    public Object get(Object obj) {
        return this.readAccessor.invoke(obj, null);
    }

    @Override
    public void set(Object obj, Object value) {
        this.writeAccessor.invoke(obj, new Object[]{value});
    }

    @Override
    public Method getReadMethod() {
        return this.readAccessor.getMethod();
    }

    @Override
    public Method getWriteMethod() {
        return this.writeAccessor.getMethod();
    }
}

