/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.reflect;

import cn.taketoday.context.asm.ClassVisitor;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.CglibReflectUtils;
import cn.taketoday.context.cglib.core.ClassEmitter;
import cn.taketoday.context.cglib.core.ClassGenerator;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.EmitUtils;
import cn.taketoday.context.cglib.core.MethodInfo;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.exception.ContextException;
import cn.taketoday.context.logger.LoggerFactory;
import cn.taketoday.context.reflect.GeneratorSupport;
import cn.taketoday.context.reflect.Invoker;
import cn.taketoday.context.reflect.MethodAccessor;
import cn.taketoday.context.reflect.MethodMethodAccessor;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;

public abstract class MethodInvoker
implements MethodAccessor,
Invoker {
    private final Method method;

    public MethodInvoker(Method method) {
        Assert.notNull((Object)method, "method must not be null");
        this.method = method;
    }

    @Override
    public abstract Object invoke(Object var1, Object[] var2);

    @Override
    public Method getMethod() {
        return this.method;
    }

    public static MethodInvoker create(Method executable) {
        return (MethodInvoker)new MethodInvokerGenerator(executable).create();
    }

    public static MethodInvoker create(Method executable, Class<?> targetClass) {
        return (MethodInvoker)new MethodInvokerGenerator(executable, targetClass).create();
    }

    public static MethodInvoker create(Class<?> beanClass, String name, Class<?> ... parameters) throws NoSuchMethodException {
        Method targetMethod = beanClass.getDeclaredMethod(name, parameters);
        return (MethodInvoker)new MethodInvokerGenerator(targetMethod, beanClass).create();
    }

    static class MethodInvokerCacheKey {
        int hash;
        final Method targetMethod;
        final Class<?> targetClass;

        MethodInvokerCacheKey(Method targetMethod, Class<?> targetClass) {
            this.targetMethod = targetMethod;
            this.targetClass = targetClass;
            this.hash = Objects.hash(targetMethod, targetClass);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodInvokerCacheKey)) {
                return false;
            }
            MethodInvokerCacheKey that = (MethodInvokerCacheKey)o;
            return Objects.equals(this.targetMethod, that.targetMethod) && Objects.equals(this.targetClass, that.targetClass);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    public static class MethodInvokerGenerator
    extends GeneratorSupport<MethodInvoker>
    implements ClassGenerator {
        private final Method targetMethod;
        private static final String superType = "Lcn/taketoday/context/reflect/MethodInvoker;";
        private static final String[] interfaces = new String[]{"Lcn/taketoday/context/reflect/Invoker;"};
        private static final MethodInfo invokeInfo;
        private static final Signature SIG_CONSTRUCTOR;

        public MethodInvokerGenerator(Method method) {
            this(method, method.getDeclaringClass());
        }

        public MethodInvokerGenerator(Method method, Class<?> targetClass) {
            super(targetClass);
            Assert.notNull((Object)method, "method must not be null");
            this.targetMethod = ClassUtils.getMostSpecificMethod(method, targetClass);
        }

        @Override
        public void generateClass(ClassVisitor v) {
            Method target = this.targetMethod;
            ClassEmitter classEmitter = this.beginClass(v);
            CodeEmitter codeEmitter = EmitUtils.beginMethod(classEmitter, invokeInfo, 17);
            if (!Modifier.isStatic(target.getModifiers())) {
                codeEmitter.visitVarInsn(25, 1);
                codeEmitter.checkcast(Type.getType(this.targetClass));
            }
            this.prepareParameters(codeEmitter, target);
            MethodInfo methodInfo = CglibReflectUtils.getMethodInfo(target);
            codeEmitter.invoke(methodInfo);
            codeEmitter.box(Type.getType(target.getReturnType()));
            codeEmitter.return_value();
            codeEmitter.end_method();
            classEmitter.endClass();
        }

        @Override
        protected void generateConstructor(ClassEmitter ce) {
            CodeEmitter e = ce.beginMethod(1, SIG_CONSTRUCTOR, new Type[0]);
            e.load_this();
            e.load_arg(0);
            e.super_invoke_constructor(SIG_CONSTRUCTOR);
            e.return_value();
            e.end_method();
        }

        @Override
        protected MethodInvoker newInstance(Class<MethodInvoker> accessorClass) throws NoSuchMethodException {
            Constructor<MethodInvoker> constructor = accessorClass.getDeclaredConstructor(Method.class);
            return ClassUtils.newInstance(constructor, new Object[]{this.targetMethod});
        }

        @Override
        protected String createClassName() {
            StringBuilder builder = new StringBuilder(this.targetClass.getName());
            builder.append('$').append(this.targetMethod.getName());
            this.buildClassNameSuffix(builder, this.targetMethod);
            return builder.toString();
        }

        @Override
        protected MethodInvoker fallback(Exception exception) {
            LoggerFactory.getLogger(MethodInvokerGenerator.class).warn("Cannot access a Method: [{}]", (Object)this.targetMethod, (Object)exception);
            return (MethodInvoker)super.fallback(exception);
        }

        @Override
        protected MethodInvoker fallbackInstance() {
            return new MethodMethodAccessor(this.targetMethod);
        }

        @Override
        protected boolean cannotAccess() {
            return Modifier.isPrivate(this.targetClass.getModifiers()) || Modifier.isPrivate(this.targetMethod.getModifiers());
        }

        @Override
        protected ClassGenerator getClassGenerator() {
            return this;
        }

        @Override
        protected Object cacheKey() {
            return new MethodInvokerCacheKey(this.targetMethod, this.targetClass);
        }

        @Override
        public String getSuperType() {
            return superType;
        }

        @Override
        public String[] getInterfaces() {
            return interfaces;
        }

        static {
            SIG_CONSTRUCTOR = new Signature("<init>", "(Ljava/lang/reflect/Method;)V");
            try {
                invokeInfo = CglibReflectUtils.getMethodInfo(MethodInvoker.class.getDeclaredMethod("invoke", Object.class, Object[].class));
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new ContextException(e);
            }
        }
    }
}

