/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.reflect;

import cn.taketoday.context.reflect.ReadOnlyPropertyAccessor;
import cn.taketoday.context.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReadOnlyFieldPropertyAccessor
extends ReadOnlyPropertyAccessor {
    private final Field field;
    private final Method readMethod;

    public ReadOnlyFieldPropertyAccessor(Field field, Method readMethod) {
        this.readMethod = readMethod;
        this.field = ReflectionUtils.makeAccessible(field);
    }

    @Override
    public Object get(Object obj) {
        return ReflectionUtils.getField(this.field, obj);
    }

    @Override
    public Method getReadMethod() {
        return this.readMethod;
    }
}

