/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.utils;

import cn.taketoday.context.conversion.Converter;
import cn.taketoday.context.conversion.TypeConverter;
import cn.taketoday.context.conversion.support.DefaultConversionService;
import java.time.Duration;
import java.util.List;
import java.util.Objects;

public abstract class ConvertUtils {
    public static boolean supports(Object source, Class<?> targetClass) {
        return DefaultConversionService.getSharedInstance().canConvert(source, targetClass);
    }

    public static TypeConverter getConverter(Object source, Class<?> targetClass) {
        return DefaultConversionService.getSharedInstance().getConverter(source, targetClass);
    }

    public static Object convert(Object source, Class<?> targetClass) {
        return DefaultConversionService.getSharedInstance().convert(source, targetClass);
    }

    public static <T> T convert(Class<T> targetClass, Object source) {
        return (T)ConvertUtils.convert(source, targetClass);
    }

    public static List<TypeConverter> getConverters() {
        return DefaultConversionService.getSharedInstance().getConverters();
    }

    public static void setConverters(TypeConverter ... cts) {
        DefaultConversionService.getSharedInstance().setConverters(cts);
    }

    public static Duration parseDuration(String value) {
        if (Objects.requireNonNull(value, "Input string must not be null").endsWith("ns")) {
            return Duration.ofNanos(Long.parseLong(value.substring(0, value.length() - 2)));
        }
        if (value.endsWith("ms")) {
            return Duration.ofMillis(Long.parseLong(value.substring(0, value.length() - 2)));
        }
        if (value.endsWith("min")) {
            return Duration.ofMinutes(Long.parseLong(value.substring(0, value.length() - 3)));
        }
        if (value.endsWith("s")) {
            return Duration.ofSeconds(Long.parseLong(value.substring(0, value.length() - 1)));
        }
        if (value.endsWith("h")) {
            return Duration.ofHours(Long.parseLong(value.substring(0, value.length() - 1)));
        }
        if (value.endsWith("d")) {
            return Duration.ofDays(Long.parseLong(value.substring(0, value.length() - 1)));
        }
        return Duration.parse(value);
    }

    public static void addConverter(TypeConverter ... converters) {
        DefaultConversionService.getSharedInstance().addConverters(converters);
    }

    public static void addConverter(List<TypeConverter> converters) {
        DefaultConversionService.getSharedInstance().addConverters(converters);
    }

    public static void addConverters(Converter<?, ?> ... converters) {
        DefaultConversionService.getSharedInstance().addConverters(converters);
    }

    public static <S, T> void addConverter(Converter<S, T> converter) {
        DefaultConversionService.getSharedInstance().addConverter(converter);
    }

    public static <S, T> void addConverter(Class<T> targetType, Converter<? super S, ? extends T> converter) {
        DefaultConversionService.getSharedInstance().addConverter(targetType, converter);
    }

    public static <S, T> void addConverter(Class<T> targetType, Class<S> sourceType, Converter<? super S, ? extends T> converter) {
        DefaultConversionService.getSharedInstance().addConverter(targetType, sourceType, converter);
    }
}

